// KPPPLoad - a PPP load monitor
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _OptionsDlg_h_
#define _OptionsDlg_h_

#include <qdialog.h>

class QCheckBox;
class QLineEdit;
class QPushButton;

class KColorButton;

class OptionsDlg : public QDialog {
    Q_OBJECT
    QCheckBox*    _txRate;
    QCheckBox*    _rxRate;
    QCheckBox*    _txTotal;
    QCheckBox*    _rxTotal;
    QCheckBox*    _linkStatus;
    QLineEdit*    _statsInterval;
    QLineEdit*    _statsPeriod;
    QLineEdit*    _rateDivider;
    KColorButton* _txColor;
    KColorButton* _rxColor;
    QLineEdit*    _pppCommand;
    QLineEdit*    _retryInterval;
    QLineEdit*    _periodicCommand;
    QLineEdit*    _periodicInterval;
public:
    OptionsDlg( QWidget* parent = 0, const char* name = 0 );
    ~OptionsDlg();
public slots:
    void slotOk();
    void slotApply();
    void slotCancel();
};

#endif
