/* An abstract data type for regions, defined over an integer grid. */

#ifndef REGION_H
#define REGION_H

/* rect.h also defines bool, rect, and point. */
#include "rect.h"

#ifndef BYTE_DEFINED
#define BYTE_DEFINED
typedef unsigned char byte;
#endif

#ifndef INF
#define INF 0x7fffffff
#endif

typedef struct range {
  int x0, x1;
} range;

typedef struct band {
  int refcount;
  int y0, y1;
  int n_ranges;
  range range[1];
} band;

/* An invariant: band[i]->y1 <= band[i+1]->y0 */
typedef struct region {
  int refcount;
  int n_bands;
  band *band[1];
} region;

/* Regions are dynamically allocated, and reference counted. Most
   functions for manipulating regions will decrement the reference
   count of the arguments, and create a new region with a reference
   count of 1. */

region *region_pin (region *region);
void region_drop (region *region);
region *region_from_rect (const rect *src);
bool region_empty (const region *region);

/* There should probably also be a region_sanitycheck for testing
   purposes. */

/* Standard set operations on regions. */
region *region_union (region *src1, region *src2);
region *region_intersect (region *src1, region *src2);
region *region_minus (region *src1, region *src2);

void region_tile (rect *dst, region *src, int max_xs, int max_ys, int waste);

void region_to_bitmap (region *src, byte *buf, int xs, int ys);

#endif
