/*	$Id: err.c,v 1.2 1999/09/30 05:14:12 lukem Exp $	*/

/*
 * Copyright 1997, 1998 Luke Mewburn <lukem@netbsd.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "lukemftp.h"

extern char *__progname;

void
#ifdef __STDC__
err(int eval, const char *fmt, ...)
#else
err(eval, va_alist)
	int eval;
	va_dcl
#endif
{
	va_list	ap;
        int	sverrno;
#ifndef __STDC__
	char   *fmt;
#endif

	sverrno = errno;
        (void)fprintf(stderr, "%s: ", __progname);
	VA_START(ap, fmt);
	VA_ARG(fmt, ap, char *);
        if (fmt != NULL) {
                (void)vfprintf(stderr, fmt, ap);
                (void)fprintf(stderr, ": ");
        }
	va_end(ap);
        (void)fprintf(stderr, "%s\n", strerror(sverrno));
        exit(eval);
}

void
#ifdef __STDC__
errx(int eval, const char *fmt, ...)
#else
errx(eval, va_alist)
	int eval;
	va_dcl
#endif
{
	va_list	ap;
        int	sverrno;
#ifndef __STDC__
	char   *fmt;
#endif

	sverrno = errno;
        (void)fprintf(stderr, "%s: ", __progname);
	VA_START(ap, fmt);
	VA_ARG(fmt, ap, char *);
        if (fmt != NULL)
                (void)vfprintf(stderr, fmt, ap);
	va_end(ap);
        (void)fprintf(stderr, "\n");
        exit(eval);
}

void
#ifdef __STDC__
warn(const char *fmt, ...)
#else
warn(va_alist)
	va_dcl
#endif
{
	va_list	ap;
        int	sverrno;
#ifndef __STDC__
	char   *fmt;
#endif

	sverrno = errno;
        (void)fprintf(stderr, "%s: ", __progname);
	VA_START(ap, fmt);
	VA_ARG(fmt, ap, char *);
        if (fmt != NULL) {
                (void)vfprintf(stderr, fmt, ap);
                (void)fprintf(stderr, ": ");
        }
	va_end(ap);
        (void)fprintf(stderr, "%s\n", strerror(sverrno));
}

void
#ifdef __STDC__
warnx(const char *fmt, ...)
#else
warnx(va_alist)
	va_dcl
#endif
{
	va_list	ap;
        int	sverrno;
#ifndef __STDC__
	char   *fmt;
#endif

	sverrno = errno;
        (void)fprintf(stderr, "%s: ", __progname);
	VA_START(ap, fmt);
	VA_ARG(fmt, ap, char *);
        if (fmt != NULL)
                (void)vfprintf(stderr, fmt, ap);
	va_end(ap);
        (void)fprintf(stderr, "\n");
}
