/*******************************************************************/
/* (C) Klangatelier Algorythmics                                   */
/*******************************************************************/
/* MIDI Definitions from MIDI Specifications V1.00, IMA 1989 */
/* some typedefs and so on */

#ifndef MIDIDEFS_H
#define MIDIDEFS_H
/* -------------------------------------------------------------------- */
/*       Typendefinition.                                               */
/* -------------------------------------------------------------------- */
#ifndef TRUE
typedef enum {    FALSE,    TRUE} boolean;
#endif

typedef unsigned char uchar; /* MIDI Byte 8 Bit */
typedef unsigned char byte;  /* MIDI Byte 8 Bit */

/* MIDI String - mostly for sysexdata or unparsed MIDI*/
typedef struct {
  int len;
  byte* data;
} MIDIstr;

typedef struct {
  byte type;
  int len;
  byte* data;
} METAstr;


/* MIDI Data are one or two data bytes or a string (for sysex) */ 


/* MIDI event is status + data */
typedef struct {

  byte status;

  union MIDIdata {
	 byte message[2];
	 MIDIstr *sysex_data;
	 METAstr *meta_data;
  } data;

}MIDIevt;

/* Maximal Message length (for sysex) */
#define MD_MAX_MESSAGE_LEN 256 
/* MIDI Spec. V1.00: only 256, but some have a header...;-) */

#define md_msglen(x) (((x)<0xC0)?2:((x)<0xE0)?1:((x)<0xF0)?2:\
							 ((x)==0xF2)?2:((x)<0xF4)?1:0)

/* Status groups */
#define MD_NOTE_OFF       0x80
#define MD_NOTE_ON        0x90
#define MD_POLY_TOUCH     0xA0
#define MD_CONTROL_CHANGE 0xB0
#define MD_PROGRAM_CHANGE 0xC0
#define MD_CHANNEL_TOUCH  0xD0
#define MD_PITCH_BEND     0xE0
#define MD_SYS_MESSAGES   0xF0

/* CONTROLS: MODE Messages 1.Byte*/
#define MD_MODE_MESSAGES    0x78
#define MD_MODE_RESET       121
#define MD_MODE_LOCAL       122
#define MD_MODE_ALLNOTESOFF 123
#define MD_MODE_OMNI_OFF    124
#define MD_MODE_OMNI_ON     125
#define MD_MODE_MONO_ON     126
#define MD_MODE_POLY_ON     127

/* System Messages */
#define MD_SYS_EXCLUSIV      0xF0
#define MD_SYS_MTC_QUARTER   0xF1
#define MD_SYS_SONG_POSITION 0xF2
#define MD_SYS_SONG_SELECT   0xF3
#define MD_SYS_TUNE_REQUEST  0xF6
#define MD_SYS_END_OF_SYSEX  0xF7

/* realtime */
#define MD_SYS_TIMING_CLOCK   0xF8
#define MD_SYS_START          0xFA
#define MD_SYS_CONTINUE       0xFB
#define MD_SYS_STOP           0xFC
#define MD_SYS_ACTIVE_SENSE   0xFE
#define MD_SYS_SYSTEM_RESET   0xFF /* ambigues: for midi streams */
#define MD_SYS_META_EVENT     0xFF /* for midifiles ! */
/* Sysex Befehle */


/* NON REALTIME */
#define MD_SYSEX_NRT           0X7E /* GENERAL ID */

/* sub-id */
#define MD_SYSEX_SAMPLE_DH     0x01 /* sample dump header */ 
#define MD_SYSEX_SAMPLE_DP     0x02 /* sample data packet */ 
#define MD_SYSEX_SAMPLE_DR     0x03 /* sample dump request */ 
#define MD_SYSEX_SAMPLE_EX     0x05 /* sample dump extension id 1*/ 
#define MD_SYSEX_SAMPLE_EX_MLP 0x01 /* sample dump extension id2 = Multiple loop points */ 
#define MD_SYSEX_SAMPLE_EX_LPR 0x01 /* sample dump extension id2 = loop points request*/ 

#define MD_SYSEX_MTC           0x04 /* MIDI Time Code id 1 */
#define MD_SYSEX_MTC_SPECIAL   0x00 /* MIDI Time Code id 2:Special */
#define MD_SYSEX_MTC_PINP      0x01 /* MIDI Time Code id 2: Punch IN points */
#define MD_SYSEX_MTC_POUTP     0x02 /* MIDI Time Code id 2: Punch out points*/
#define MD_SYSEX_MTC_DPINP     0x03 /* MIDI Time Code id 2: Delete Punch in point*/
#define MD_SYSEX_MTC_DPOUTP    0x04 /* MIDI Time Code id 2: Delete Punch out points*/
#define MD_SYSEX_MTC_ESTARTP   0x05 /* MIDI Time Code id 2: Event Start Point*/
#define MD_SYSEX_MTC_ESTOPP    0x06 /* MIDI Time Code id 2: Event Stop point*/
#define MD_SYSEX_MTC_ESTARTPI  0x07 /* MIDI Time Code id 2: Event Start Point with info*/
#define MD_SYSEX_MTC_ESTOPI    0x08 /* MIDI Time Code id 2: Event Stop Point with info*/
#define MD_SYSEX_MTC_DESTARTP  0x09 /* MIDI Time Code id 2: Delete Event start point*/
#define MD_SYSEX_MTC_DESTOPP   0x0A /* MIDI Time Code id 2: Delete Event Stop point*/
#define MD_SYSEX_MTC_CUEP      0x0B /* MIDI Time Code id 2: Cue points*/
#define MD_SYSEX_MTC_CUEPI     0x0C /* MIDI Time Code id 2: Cue points with additional info*/
#define MD_SYSEX_MTC_DCUEP     0x0D /* MIDI Time Code id 2: Delete Cue point*/
#define MD_SYSEX_MTC_ENAMEI    0x0E /* MIDI Time Code id 2: Event name with additional info */

#define MD_SYSEX_GINFO         0x06 /* General info id 1 */
#define MD_SYSEX_GINFO_IDREQ   0x01 /* General info id 2: ID request */
#define MD_SYSEX_GINFO_IDREP   0x02 /* General info id 2: ID reply */

/* handshake */
#define MD_SYSEX_WAIT          0x7C /* Wait */
#define MD_SYSEX_CANCEL        0x7C /* Cancel */
#define MD_SYSEX_NAK           0x7C /* NAK */
#define MD_SYSEX_ACK           0x7C /* ACK */

/* REALTIME */
#define MD_SYSEX_RT            0X7F /* GENERAL ID */
/* SUB IDS : */
#define MD_SYSEX_RT_MTC        0X01 /* Realtime MIDI Time Code sub-id 1*/
#define MD_SYSEX_RT_MTC_FULL   0x01 /* Realtime MTC sub-id 2: Full message */
#define MD_SYSEX_RT_MTC_USERB  0x02 /* Realtime MTC sub-id 2: User bits */

#endif /* MIDI_H */
