#ifndef BZ_ARRAY_H
 #error <blitz/array/io.cc> must be included via <blitz/array.h>
#endif

#ifndef BZ_ARRAYIO_CC
#define BZ_ARRAYIO_CC

BZ_NAMESPACE(blitz)

template<class T_numtype>
ostream& operator<<(ostream& os, const Array<T_numtype,1>& x)
{
    os << "[ ";
    for (int i=x.lbound(firstRank); i <= x.ubound(firstRank); ++i)
    {
        os << setw(10) << x(i);
        if (!((i+1)%7))
            os << endl << "  ";
    }
    os << " ]";
    return os;
}

template<class T_numtype>
ostream& operator<<(ostream& os, const Array<T_numtype,2>& x)
{
    os << x.rows() << " x " << x.columns() << endl;
    for (int i=x.lbound(firstRank); i <= x.ubound(firstRank); ++i)
    {
        for (int j=x.lbound(secondRank); j <= x.ubound(secondRank); ++j)
        {
            os << setw(10) << x(i,j);
            if (!((j+1)%7))
                os << endl << "  ";
        }
        os << endl;
    }

    return os;
}

BZ_NAMESPACE_END

#endif // BZ_ARRAYIO_CC
