#include <X11/Xlocale.h>
#include <stdarg.h>

#ifdef X_LOCALE
#define mblen(a, b) _Xmblen((a), (b))
#endif
 
#ifdef FreeBSD
#define JP_LOCALE "ja_JP.EUC"
#elif defined(Solaris)
#define JP_LOCALE "japanese"
#elif defined(X_LOCALE)
#define JP_LOCALE "ja_JP.eucJP"
#else
#define JP_LOCALE "ja_JP.ujis"
#endif
 
void title()
{
  printf( "locale type: " );
#ifndef X_LOCALE
  printf ( "LIBC_LOCALE\n" );
#else
  printf ( "X_LOCALE\n" );
#endif
}

void check(char* str)
{
  printf ("[%2d] %s\n", mblen(str, 4), str);
}

void chglocale(char* str)
{
  printf ( "set to %s\n", setlocale(LC_ALL, str));
  printf ( "current locale: %s\n", setlocale(LC_ALL, NULL) );
}

void main ()
{
  title();
  chglocale(JP_LOCALE);
  check("");	/* should be 2 */
  check("ABC");		/* should be 1 */
  chglocale("fr_FR");  
  check("");	/* should be -1 */
  check("ABC");		/* should be 1 */
  chglocale("C"); 
  check("");	/* should be -1 */
  check("ABC");		/* should be 1 */
  chglocale(JP_LOCALE);
  check("");	/* should be 2 */
  check("ABC");		/* should be 1 */
}
