/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions.                                 */


#include <stdio.h>
#include <math.h>

#include "defs.h"

#ifdef KPATHSEA
#include <kpathsea/tex-file.h>
#endif

#include "globals.h"
#include "subs.h"
#include "readtfm.h"



FILE *fofile;

/*
An encodingscheem must be an 256x5 array as below. Each element 
has to be the string representing the glyph on that position.
Only A..Z, a..z, 0..9 and " are allowed.
The name of the encodingscheem has to be put in the below array of
encodingnames. A pointer to the encodingschemm has to be put at the
corresponding position in the array of encodings. The below 
NUMBEROFENCODINGS has to be set.
*/


char encodingTeXtext[256][5]={
   /* 00 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 08 */ "",  "",  "",  "ff",  "fi",  "fl",  "ffi",  "ffl",
   /* 10 */ "i",  "j",  "\"",  "\"",  "\"",  "\"",  "\"",  "\"",
   /* 18 */ "\"",  "\"s",  "ae",  "oe",  "o",  "AE",  "OE",  "O",
   /* 20 */ "\"",  "",  "",  "",  "",  "",  "",  "",
   /* 28 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 30 */ "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
   /* 38 */ "8",  "9",  "",  "",  "",  "",  "",  "",
   /* 40 */ "",  "A",  "B",  "C",  "D",  "E",  "F",  "G",
   /* 48 */ "H",  "I",  "J",  "K",  "L",  "M",  "N",  "O",
   /* 50 */ "P",  "Q",  "R",  "S",  "T",  "U",  "V",  "W",
   /* 58 */ "X",  "Y",  "Z",  "",  "",  "",  "\"",  "\"",
   /* 60 */ "",  "a",  "b",  "c",  "d",  "e",  "f",  "g",
   /* 68 */ "h",  "i",  "j",  "k",  "l",  "m",  "n",  "o",
   /* 70 */ "p",  "q",  "r",  "s",  "t",  "u",  "v",  "w",
   /* 78 */ "x",  "y",  "z",  "",  "",  "",  "\"",  "\"",
   /* 80 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 88 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 90 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 98 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f8 */ "",  "",  "",  "",  "",  "",  "",  "",
};

char encodingTeXmathitalic[256][5]={
   /* 00 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 08 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 10 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 18 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 20 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 28 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 30 */ "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
   /* 38 */ "8",  "9",  "",  "",  "",  "",  "",  "",
   /* 40 */ "",  "A",  "B",  "C",  "D",  "E",  "F",  "G",
   /* 48 */ "H",  "I",  "J",  "K",  "L",  "M",  "N",  "O",
   /* 50 */ "P",  "Q",  "R",  "S",  "T",  "U",  "V",  "W",
   /* 58 */ "X",  "Y",  "Z",  "",  "",  "",  "",  "",
   /* 60 */ "l",  "a",  "b",  "c",  "d",  "e",  "f",  "g",
   /* 68 */ "h",  "i",  "j",  "k",  "l",  "m",  "n",  "o",
   /* 70 */ "p",  "q",  "r",  "s",  "t",  "u",  "v",  "w",
   /* 78 */ "x",  "y",  "z",  "i",  "j",  "",  "\"",  "\"",
   /* 80 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 88 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 90 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 98 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f8 */ "",  "",  "",  "",  "",  "",  "",  "",
};
   
char encodingASCII[256][5]={
   /* 00 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 08 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 10 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 18 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 20 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 28 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 30 */ "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
   /* 38 */ "8",  "9",  "",  "",  "",  "",  "",  "",
   /* 40 */ "",  "A",  "B",  "C",  "D",  "E",  "F",  "G",
   /* 48 */ "H",  "I",  "J",  "K",  "L",  "M",  "N",  "O",
   /* 50 */ "P",  "Q",  "R",  "S",  "T",  "U",  "V",  "W",
   /* 58 */ "X",  "Y",  "Z",  "",  "",  "",  "",  "",
   /* 60 */ "",  "a",  "b",  "c",  "d",  "e",  "f",  "g",
   /* 68 */ "h",  "i",  "j",  "k",  "l",  "m",  "n",  "o",
   /* 70 */ "p",  "q",  "r",  "s",  "t",  "u",  "v",  "w",
   /* 78 */ "x",  "y",  "z",  "",  "",  "",  "",  "",
   /* 80 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 88 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 90 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 98 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f8 */ "",  "",  "",  "",  "",  "",  "",  "",
};
   
char encodingTeXtypewritertext[256][5]={
   /* 00 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 08 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 10 */ "i",  "j",  "\"",  "\"",  "\"",  "\"",  "\"",  "\"",
   /* 18 */ "",  "\"s",  "ae",  "oe",  "o",  "AE",  "OE",  "O",
   /* 20 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 28 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 30 */ "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
   /* 38 */ "8",  "9",  "",  "",  "",  "",  "",  "",
   /* 40 */ "",  "A",  "B",  "C",  "D",  "E",  "F",  "G",
   /* 48 */ "H",  "I",  "J",  "K",  "L",  "M",  "N",  "O",
   /* 50 */ "P",  "Q",  "R",  "S",  "T",  "U",  "V",  "W",
   /* 58 */ "X",  "Y",  "Z",  "",  "",  "",  "",  "",
   /* 60 */ "",  "a",  "b",  "c",  "d",  "e",  "f",  "g",
   /* 68 */ "h",  "i",  "j",  "k",  "l",  "m",  "n",  "o",
   /* 70 */ "p",  "q",  "r",  "s",  "t",  "u",  "v",  "w",
   /* 78 */ "x",  "y",  "z",  "",  "",  "",  "\"",  "\"",
   /* 80 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 88 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 90 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 98 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f8 */ "",  "",  "",  "",  "",  "",  "",  "",
};
   
char encodingTeXmathsymbols[256][5]={
   /* 00 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 08 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 10 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 18 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 20 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 28 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 30 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 38 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 40 */ "",  "A",  "B",  "C",  "D",  "E",  "F",  "G",
   /* 48 */ "H",  "I",  "J",  "K",  "L",  "M",  "N",  "O",
   /* 50 */ "P",  "Q",  "R",  "S",  "T",  "U",  "V",  "W",
   /* 58 */ "X",  "Y",  "Z",  "",  "",  "",  "",  "",
   /* 60 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 68 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 70 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 78 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 80 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 88 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 90 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 98 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f8 */ "",  "",  "",  "",  "",  "",  "",  "",
};   

char encodingDC[256][5]={
   /* 00 */ "\"",  "\"",  "\"",  "\"",  "\"",  "\"",  "\"",  "\"",
   /* 08 */ "\"",  "\"",  "\"",  "",  "",  "",  "",  "",
   /* 10 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 18 */ "",  "i",  "j",  "ff",  "fi",  "fl",  "ffi",  "ffl",
   /* 20 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 28 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 30 */ "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
   /* 38 */ "8",  "9",  "",  "",  "",  "",  "",  "",
   /* 40 */ "",  "A",  "B",  "C",  "D",  "E",  "F",  "G",
   /* 48 */ "H",  "I",  "J",  "K",  "L",  "M",  "N",  "O",
   /* 50 */ "P",  "Q",  "R",  "S",  "T",  "U",  "V",  "W",
   /* 58 */ "X",  "Y",  "Z",  "",  "",  "",  "\"",  "",
   /* 60 */ "",  "a",  "b",  "c",  "d",  "e",  "f",  "g",
   /* 68 */ "h",  "i",  "j",  "k",  "l",  "m",  "n",  "o",
   /* 70 */ "p",  "q",  "r",  "s",  "t",  "u",  "v",  "w",
   /* 78 */ "x",  "y",  "z",  "",  "",  "",  "\"",  "",
   /* 80 */ "\"A",  "A",  "\"C",  "\"C",  "\"D",  "\"E",  "E",  "\"G",
   /* 88 */ "\"L",  "L",  "L",  "\"N",  "\"N",  "",  "\"O",  "\"R",
   /* 90 */ "\"R",  "\"S",  "\"S",  "S",  "\"T",  "T",  "\"U",  "\"U",
   /* 98 */ "\"Y",  "\"Z",  "\"Z",  "\"Z",  "IJ",  "\"I",  "d",  "",
   /* a0 */ "\"a",  "a",  "\"c",  "\"c",  "\"d",  "\"e",  "e",  "\"g",
   /* a8 */ "\"l",  "l",  "l",  "\"n",  "\"n",  "",  "\"o",  "\"r",
   /* b0 */ "\"r",  "\"s",  "\"s",  "s",  "\"t",  "t",  "\"u",  "\"u",
   /* b8 */ "\"y",  "\"z",  "\"z",  "\"z",  "ij",  "",  "",  "",
   /* c0 */ "\"A",  "\"A",  "\"A",  "\"A",  "\"A",  "\"A",  "AE",  "C",
   /* c8 */ "\"E",  "\"E",  "\"E",  "\"E",  "\"I",  "\"I",  "\"I",  "\"I",
   /* d0 */ "D",  "\"N",  "\"O",  "\"O",  "\"O",  "\"O",  "\"O",  "OE",
   /* d8 */ "O",  "\"U",  "\"U",  "\"U",  "\"U",  "\"Y",  "",  "SS",
   /* e0 */ "\"a",  "\"a",  "\"a",  "\"a",  "\"a",  "\"a",  "ae",  "c",
   /* e8 */ "\"e",  "\"e",  "\"e",  "\"e",  "\"i",  "\"i",  "\"i",  "\"i",
   /* f0 */ "d",  "\"n",  "\"o",  "\"o",  "\"o",  "\"o",  "\"o",  "oe",
   /* f8 */ "o",  "\"u",  "\"u",  "\"u",  "\"u",  "\"y",  "",  "\"s",
};
   
char encodingAdobe[256][5]={
   /* 00 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 08 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 10 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 18 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 20 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 28 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 30 */ "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
   /* 38 */ "8",  "9",  "",  "",  "",  "",  "",  "",
   /* 40 */ "",  "A",  "B",  "C",  "D",  "E",  "F",  "G",
   /* 48 */ "H",  "I",  "J",  "K",  "L",  "M",  "N",  "O",
   /* 50 */ "P",  "Q",  "R",  "S",  "T",  "U",  "V",  "W",
   /* 58 */ "X",  "Y",  "Z",  "",  "",  "",  "",  "",
   /* 60 */ "",  "a",  "b",  "c",  "d",  "e",  "f",  "g",
   /* 68 */ "h",  "i",  "j",  "k",  "l",  "m",  "n",  "o",
   /* 70 */ "p",  "q",  "r",  "s",  "t",  "u",  "v",  "w",
   /* 78 */ "x",  "y",  "z",  "",  "",  "",  "",  "",
   /* 80 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 88 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 90 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* 98 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* a8 */ "",  "",  "",  "",  "",  "",  "fi",  "fl",
   /* b0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* b8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* c0 */ "\"",  "\"",  "\"",  "\"",  "\"",  "\"",  "\"",  "\"",
   /* c8 */ "\"",  "\"",  "\"",  "\"",  "\"",  "\"",  "\"",  "\"",
   /* d0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* d8 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* e0 */ "",  "AE",  "",  "a",  "",  "",  "",  "",
   /* e8 */ "L",  "O",  "OE",  "",  "",  "",  "",  "",
   /* f0 */ "",  "",  "",  "",  "",  "",  "",  "",
   /* f8 */ "l",  "o",  "oe",  "\"s",  "",  "",  "",  "",
};

#define NUMBEROFENCODINGS 8

char* encodingnames[]={
  "TeX text",
  "ASCII",
  "TeX math italic",
  "TeX math symbols",
  "TeX typewriter text",
  "Extended TeX Font Encoding",
  "dc.vec",
  "Adobe StandardEncoding",
};

void* encodings[]={
  encodingTeXtext,
  encodingASCII, 
  encodingTeXmathitalic,
  encodingTeXmathsymbols,
  encodingTeXtypewritertext,
  encodingDC,
  encodingDC,
  encodingAdobe,
};   


static uchar fofbyte(void) {  uchar b;
  if (fread(&b, 1, 1, fofile) <= 0) b = 0;  return b;
}

static long fofint(uchar b)  {  uchar i;  long n;
  n = fofbyte();  if (n > 127)  n -= 256;
  for (i = 2; i <= b; i++)  n = (n << 8) | fofbyte();
  return n;
}

int tfmfind(char *ffpath,char *fontname,char *fftotal) {  
  char ffname[MAXPATHSTR];
  int foundfile;

#ifdef KPATHSEA
  char *name=NULL;

  name = kpse_find_tfm(fontname);
  foundfile = (name!=NULL);
  if(name){
    strcpy(fftotal, name);
    freemem(&name);
  }         
#else
  sprintf(ffname, "%s.tfm", fontname);
  foundfile = msearch(ffpath,ffname,fftotal);
#endif

  if(!foundfile){
     pfprot(" - no TFMfile ");
     return(0); 
  }
  pfprot(" - TFMfile ");   
  pfverb("%s ", fftotal);   
  return(1);
}


int tfmdef(char *fftotal,int fdb,long chksum) {  
  short ll, lh, bc, ec, nw, nh, nd, i,j;
  uchar b1, b2, b3;  short FORLIM;
  fontdesc *font;
  char encstr[41];
  float designsize;
  long dummy[256];
  long fofchk;
  fofile = fopen(fftotal, "rb");
  font=fontdatabase+fdb;
  if (fofile==0)   return(0);  /*this cant happen */
  ll = fofint(2);  
  lh = fofint(2);  
  bc = fofint(2);  
  ec = fofint(2);
  nw = fofint(2);  
  nh = fofint(2);  
  nd = fofint(2);  
  fseek(fofile, 0L, 2);
  if (ll * 4 > ftell(fofile) || ll < lh + ec - bc + nw + nh + nd + 7) {
    pfprot(" - not a TFMfile ");  
    fclose(fofile);  
    return(0);
  }
  if(font->mch < ec) font->mch = ec;
  fseek(fofile, 24L, 0);  
  fofchk = fofint(4);
  if (chksum != 0) if (fofchk != 0) if (chksum != fofchk)
    pfverb(" - wrong checksum ");
  designsize=fofint(4)*exp(-20*log(2));
  /* fprintf(prot,"(designsize: %5.2f)", designsize);fflush(prot); */
  i=fofbyte();
  for(j=0;j<i;j++) 
    encstr[j]=fofbyte();
  encstr[j]=0;
  pfverb(" - encoding: %s ",encstr); 
  for(i=0;i<NUMBEROFENCODINGS; i++) 
    if(STRCASECMP(encodingnames[i],encstr)==0)
      font->encoding=encodings[i]; 
  if(font->encoding) 
    pfverb(": known ");
  else {   
    for(i=0;i<NUMBEROFENCODINGS; i++) 
      if(STRNCASECMP(encodingnames[i],encstr,strlen(encodingnames[i]))==0)
        font->encoding=encodings[i], j=i; 
    if(font->encoding) 
      pfverb(": assuming %s ",encodingnames[j]);
  }   
  fseek(fofile, (lh + ec - bc + 7L) * 4, 0);
  FORLIM = nw + nh + nd;
  for (i = 0; i < FORLIM; i++)
    dummy[i] = scaled(fofint(4), font->foscf);
  fseek(fofile, lh * 4L + 24, 0);
  for (i = bc; i <= ec; i++) {
    b1 = fofbyte();  b2 = fofbyte();  fofbyte();  fofbyte();
    font->chv[i].fontdataptr=fdb;
    font->chv[i].ch=i;
    font->chv[i].tfmtfw = dummy[b1];
    font->chv[i].tfmtfh = dummy[nw + (b2 >> 4)];
    font->chv[i].tfmtfd = dummy[nw + nh + (b2 & 15)];
    font->chv[i].fty |= TFMTYPE;  
  }
  fclose(fofile);  
  pfverb(" - TFMfile ok ");
  return(1);
}





