/*
 * System dependent file for BSD derivatives that have _cp_time in their
 * kernels to hold the CPU states. Seen to work on SunOS and Ultrix.
 */
/* Chris Siebenmann, CSRI, University of Toronto <cks@white.toronto.edu> */
/* LINTLIBRARY */
#include <stdio.h>
#include <fcntl.h>
#include <sys/param.h>
#ifdef	__FreeBSD__
#include <sys/dkstat.h>
#endif
#include <nlist.h>
#include <unistd.h>

#ifndef MAXHOSTNAMELEN
  /* Some U*x deviants managed to not have this in sys/param.h */
# define MAXHOSTNAMELEN 64
#endif

#ifdef	__FreeBSD__
#define	KERNEL_FILE	"/kernel"
#else
#define	KERNEL_FILE	"/vmunix"
#endif

extern char *xmalloc(/* int nbytes */);

#ifndef	__FreeBSD__
extern int open(), read();
extern long lseek();
#endif

long	cp_time[CPUSTATES];
long	cp_old[CPUSTATES];
int	kmem;			/* file descriptor of /dev/kmem. */
struct nlist	nl[] = {
#define	X_CP_TIME	0
	{ "_cp_time" },
	{ "" },
};

#define NPROCS 1

/* Called at the beginning to inquire how many bars are needed. */
int
num_bars()
{
    return NPROCS;
}

/* Called after num_bars to ask for the bar names */
/* ARGSUSED */
char **
label_bars(int nbars)
{
    static char *name[NPROCS];
    static char hname[MAXHOSTNAMELEN];

    name[0] = hname;
    if (gethostname(name[0], MAXHOSTNAMELEN) < 0) {
	perror("gethostname");
	*name[0] = '\0';
    }
    return name;
}

/* 
 *  Called after the bars are created to perform any machine dependent
 *  initializations.
 */
/* ARGSUSED */
void
init_bars(nbars)
int nbars;
{
    
    if ((kmem = open("/dev/kmem", 0)) < 0) {
	    perror("/dev/kmem");
	    exit(1);
    }
    (void)nlist(KERNEL_FILE, nl);
    if (lseek(kmem, (long) nl[X_CP_TIME].n_value, 0) !=
	(long) nl[X_CP_TIME].n_value)
	    perror("lseek");
    if (read(kmem, (char *) cp_old, sizeof(cp_old)) !=
	sizeof(cp_old))
	    perror("read kmem init_bars");
}

/* 
 *  This procedure gets called every interval to compute and display the
 *  bars. It should call draw_bar() with the bar number, the array of
 *  integer values to display in the bar, and the number of values in
 *  the array.
 */
/* ARGSUSED */
void
display_bars(int nbars)
{
	int	states[CPUSTATES];
	int	nstates;
	int	i;
	extern void draw_bar(/*int bar_num, int *states, int num_states*/);
	
	if (lseek(kmem, (long) nl[X_CP_TIME].n_value, 0) !=
	    (long) nl[X_CP_TIME].n_value)
		perror("lseek");
	if (read(kmem, (char *) cp_time, sizeof(cp_time)) !=
	    sizeof(cp_time))
		perror("read kmem display_bars");
	
	
#define delta(cpustate) ((int) (cp_time[(cpustate)] - cp_old[(cpustate)]))

	nstates = 0;
	states[nstates++] = delta(CP_IDLE);
	states[nstates++] = delta(CP_USER);
	states[nstates++] = delta(CP_NICE);
	states[nstates++] = delta(CP_SYS);
	draw_bar(0, states, nstates);
	for (i = 0; i < CPUSTATES; i ++)
		cp_old[i] = cp_time[i];
}
