#!/bin/sh

if [[ ! -f /usr/share/common-lisp/source/defsystem/defsystem.lisp ]] ; then
  cat <<EOF
$0: cannot find the defsystem source.
This should not happen. Please report this
as a bug.
EOF
  exit 0
fi


case $1 in
    rebuild)
	    echo $0 rebuilding...
	    shift
	    while [ ! -z "$1" ] ; do
		echo rebuilding $1
		/usr/bin/acl6 -qq -batch -e "
(let ((*compile-print* nil)
      (*compile-progress* nil)
      (*compile-verbose*  nil)
      (*require-verbose* nil)
      (*load-verbose* nil)
      (mk::*load-source-if-no-binary* nil)
      (mk::*bother-user-if-no-binary* nil)
      (mk::*compile-during-load* t))

   (mk:oos :$1 :compile :verbose nil))" -kill 
		shift
 	    done 
	    ;;
     remove)
	    echo $0 removing packages...
	    shift
	    while [ ! -z "$1" ] ; do
		rm -rf "/usr/lib/common-lisp/acl6/$1"
		shift
 	    done
	    rmdir /usr/lib/common-lisp/acl6 2> /dev/null 
	    ;;
    install-defsystem)
    	    echo installing the defsystem...
	    (cd /usr/lib/acl6 &&
	     ./mlisp -qq -batch -e '(progn (load "/usr/lib/acl6/install-defsystem.lisp")(build-lisp-image "lisp.dxl" :case-mode :case-insensitive-upper :include-ide nil :restart-app-function nil) (sys:copy-file "sys:mlisp" "sys:lisp"))' -kill || \
	      (echo I could not run mlisp, maybe the licence file is bad... ; exit 1 ))
    	    ;;
    remove-defsystem)
	    (cd /usr/lib/acl6 &&
	     ./mlisp -qq -batch -e '(progn (build-lisp-image "lisp.dxl" :case-mode :case-insensitive-upper :include-ide nil :restart-app-function nil) (sys:copy-file "sys:mlisp" "sys:lisp"))' -kill || \
	      (echo I could not run mlisp, maybe the licence file is bad... ; exit 1 ))
    	    ;;
    make-user-image)
    	    if [[ ! -f $2 ]] ; then 
	      echo Cannot find file $2 to load and dump!
	      exit 321
	    fi
	    (cd /usr/lib/acl6 &&
	     ./lisp -qq -batch -e "(progn (load \"$2\") (build-lisp-image \"lisp.dxl\" :case-mode :case-insensitive-upper :include-ide nil :restart-app-function nil))" -kill || \
	      (echo I could not run mlisp, maybe the licence file is bad... ; exit 1 ))
	    ;;
    *)
	    echo $0 unkown command $1
	    echo known commands: install-defsystem, remove-defsystem,rebuild and remove
	    exit 1
	    ;;
esac

exit 0
