/*********************************************************************
 *
 *	Copyright (C) 1999-2001 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * PROJECT:	JSwat
 * MODULE:	JSwat Actions
 * FILE:	AboutAction.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *	Name	Date		Description
 *	----	----		-----------
 *	nf	2/22/99		Initial version
 *
 * DESCRIPTION:
 *	This file defines the file about action.
 *
 * $Id: AboutAction.java,v 1.23 2001/08/18 07:18:31 nfiedler Exp $
 *
 ********************************************************************/

package com.bluemarsh.jswat.action;

import com.bluemarsh.jswat.util.AppVersion;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

/**
 * Implements the about file action used to show the credits
 * for the program.
 *
 * @author  Nathan Fiedler
 */
public class AboutAction extends JSwatAction {

    /**
     * Creates a new AboutAction object with the default action
     * command string of "about".
     */
    public AboutAction() {
        super("about");
    } // AboutAction

    /**
     * Performs the about action. This simply displays a dialog
     * showing the credits for the program.
     *
     * @param  event  action event
     */
    public void actionPerformed(ActionEvent event) {
        // get JSwat window that contains our invoker
        Frame win = getFrame(event);
        String version = AppVersion.getVersion();

        // content of the about dialog
        Label labels[] = {
            new Label("- JSwat " + version + " -", Label.CENTER),
            new Label(swat.getResourceString("about1"), Label.CENTER),
            new Label(swat.getResourceString("about2"), Label.CENTER),
            new Label(swat.getResourceString("about3"), Label.CENTER),
            new Label(swat.getResourceString("about4"), Label.CENTER),
            new Label(swat.getResourceString("about5"), Label.CENTER)
        };
        // display the about dialog
        JOptionPane.showMessageDialog
            (win, labels, swat.getResourceString("about.title"),
             JOptionPane.INFORMATION_MESSAGE);
    } // actionPerformed
} // AboutAction
