#ifndef _gprop_h_
#define _gprop_h_

#include <stdio.h>

typedef struct {
	enum {
		GPROP_STR ,
		GPROP_INT ,
		GPROP_BOOL ,
	} type;
	char	*name;
	void	*value;
} gprop;

extern gprop *gprop_parse(char *);
extern char *gprop_dump(gprop *);
extern void gprop_add(gprop *);
extern void gprop_set_str(char *, char *);
extern void gprop_set_int(char *, int);
extern void gprop_set_bool(char *, int);
extern int gprop_get_str(char *, char **);
extern int gprop_get_int(char *, int *);
extern int gprop_get_bool(char *, int *);
extern void gprop_save(FILE *);

#endif

