!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_vhtnzc
!! NAME
!! calc_vhtnzc
!!
!! FUNCTION
!! Compute vh(tnZc) ) and the <phi_i|vh(tnZc)|phi_j> matrix elements
!! Have to descreen it
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  option= 1: compute n_tild_Zc and Vh(n_tild_Zc) directly
!!          2: use pseudized veff from USPP
!!  pawarray
!!    %coreden4pr2(rho_meshsz)= Core density multiplied by 4Pi.r2
!!    %gnorm(l_size)= Normalisation of qijl for each l
!!    %hatden4pr2(sph_meshsz)= Compensation charge density
!!    %rvloc(rho_meshsz)= Local (effective) all-electron potential * r
!!    %shapefunc(sph_meshsz)= Normalized shape function
!!    %tcoreden4pr2(rho_meshsz)= Pseudo core density multiplied by 4Pi.r2
!!    %tvaleden4pr2(rho_meshsz)= Valence density multiplied by 4Pi.r2
!!    %valeden4pr2(rho_meshsz)= Pseudo valence density multiplied by 4Pi.r2
!!  pawdata
!!    %big_meshsz= Max. dimension of radial mesh
!!    %factzero= Factor to compute value of functions at r=0
!!    %indlmn(6,lmn_size)= Gives l,m,n,ln,lm,s for i=lmn
!!    %rad(big_meshsz)= Coordinates of the radial grid
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pshead
!!    %atomic_charge= Total atomic charge
!!    %log_step= Logaritmic step corresponding to radial mesh
!!    %rho_meshsz=Mesh size for densities inherited from uspp
!!    %sph_meshsz=Dimension of radial mesh for spheres
!!    %vloc_meshsz= Dimension of radial mesh for vloc=vhtnzc
!!  usdata
!!    %exfact= USpp s code number for the exchange-correlation
!!  un_log= Unit number for log file (comments)
!!
!! OUTPUT
!!  pawps
!!    %vhtnzc(rho_meshsz)= Hartree potential of the ps-density
!!                         of the nucleus + core electrons
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!      calc_vh,calc_vxc,ctrap
!!
!! SOURCE

 subroutine calc_vhtnzc(option,pawarray,pawdata,pawps,pshead,usdata,un_log)


  use defs_basis
  use defs_pawps

  implicit none

!Arguments ---------------------------------------------
 integer :: option,un_log
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead
 type(usdata_type)   :: usdata

!Local variables ---------------------------------------
 integer :: iexp,iexp_n,ilmn,ilm,iln,ir,j0lmn,jlmn,jlm,jln,klmn
 real(dp) :: qcore
 real(dp),allocatable :: den_1hat(:),den_1hatc(:),den_n(:),ff(:),&
&                     rtveff(:),rvh(:),rvhn(:),rvxc(:),rvxcn(:)

!--------------------------------------------------------

!--------------------------------------------------------
!First option: compute n_tild_Zc and Vh(n_tild_Zc) directly
!                                          (not used here)
!--------------------------------------------------------
 if (option==1) then
  allocate(den_n(pshead%rho_meshsz))
  den_n(1:pshead%sph_meshsz)=pawdata%rad_(1:pshead%sph_meshsz)*&
&         (pawarray%coreden4pr2(1:pshead%sph_meshsz)-pawarray%tcoreden4pr2(1:pshead%sph_meshsz))
  call ctrap(pshead%sph_meshsz,den_n,pshead%log_step,qcore)
  den_n(1:pshead%sph_meshsz)=pawarray%tcoreden4pr2(1:pshead%sph_meshsz)+&
&                    pawarray%q00hat(1:pshead%sph_meshsz)*(qcore-pshead%atomic_charge)
  den_n(pshead%sph_meshsz+1:pshead%rho_meshsz)=pawarray%coreden4pr2(pshead%sph_meshsz+1:pshead%rho_meshsz)
  allocate(rvhn(pshead%vloc_meshsz))
  rvhn(1)=zero
  call calc_vh(den_n,pshead%vloc_meshsz,pawdata,pshead,rvhn)
  do ir=2,pshead%vloc_meshsz
   pawps%vhtnzc(ir)=rvhn(ir)/pawdata%rad(ir)
  enddo
  pawps%vhtnzc(1)=pawps%vhtnzc(2)+pawdata%factzero*(pawps%vhtnzc(2)-pawps%vhtnzc(3))

  deallocate(den_n,rvhn)
 else

!--------------------------------------------------------
!2nd option: use pseudized veff from USPP
!--------------------------------------------------------
!Compute n(r)
!--------------------------------------------------------
  allocate(den_n(pshead%rho_meshsz))
  den_n=pawarray%valeden4pr2+pawarray%coreden4pr2

!Compute r*Vh(n) and r*Vxc(n)
!--------------------------------------------------------
  allocate(rvhn(pshead%vloc_meshsz),rvxcn(pshead%vloc_meshsz))
  rvhn(1)=zero;rvxcn(1)=zero
  call calc_vh (den_n,pshead%vloc_meshsz,pawdata,pshead,rvhn)
  call calc_vxc(den_n,pshead%vloc_meshsz,iexp_n,pawdata,pshead,&
&              rvxcn,usdata,un_log)

!Compute rtveff
!--------------------------------------------------------
  allocate(rtveff(pshead%vloc_meshsz));rtveff(1)=zero
  do ir=1,iexp_n
   rtveff(ir) = pawarray%rvloc(ir)/2.d0
  enddo
  do ir=iexp_n+1,pshead%vloc_meshsz
   rtveff(ir) = rvhn(ir)+rvxcn(ir)-pshead%atomic_charge
  enddo
  deallocate(den_n,rvhn,rvxcn)

!Compute: den_1hat(r) =4*pi*r^2*(tn1(r)+nhat(r))
!         den_1hatc(r)=4*pi*r^2*(tn1(r)+nhat(r)+tnc(r))
!--------------------------------------------------------
 allocate(den_1hatc(pshead%rho_meshsz),den_1hat(pshead%rho_meshsz))
  do ir=1,pshead%sph_meshsz
   den_1hat(ir)=pawarray%tvaleden4pr2(ir)+pawarray%hatden4pr2(ir)
   den_1hatc(ir)=den_1hat(ir)+pawarray%tcoreden4pr2(ir)
  enddo
  do ir=pshead%sph_meshsz+1,pshead%rho_meshsz
   den_1hat(ir) =pawarray%valeden4pr2(ir)
   den_1hatc(ir)=den_1hat(ir)+pawarray%coreden4pr2(ir)
  enddo

!Compute r*Vh(tn1+nhat) and r*Vxc(tn1+nhat+tnc)
!--------------------------------------------------------
  allocate(rvh(pshead%vloc_meshsz),rvxc(pshead%vloc_meshsz))
  rvh(1)=zero;rvxc(1)=zero
  call calc_vh (den_1hat ,pshead%vloc_meshsz,pawdata,pshead,rvh)
  call calc_vxc(den_1hatc,pshead%vloc_meshsz,iexp,pawdata,pshead,&
&               rvxc,usdata,un_log)
  deallocate(den_1hat,den_1hatc)

!Compute vhtnZc(r)=tveff(r)-Vh(tn1+nhat)-Vxc(tn1+nhat+tnc)
!---------------------------------------------------------
  do ir=2,pshead%vloc_meshsz
   pawps%vhtnzc(ir)=(rtveff(ir)-rvh(ir)-rvxc(ir))/pawdata%rad(ir)
  enddo
  pawps%vhtnzc(1)=pawps%vhtnzc(2)+pawdata%factzero*(pawps%vhtnzc(2)-pawps%vhtnzc(3))

  deallocate(rtveff,rvh,rvxc)

!--------------------------------------------------------
!End of options
!--------------------------------------------------------
 endif

!Compute matrix elements: vhtnZc_ij(r)=<tphi_i|vh(tnZc)|thpi_j>
!------------------------------------------------------------------
 allocate(ff(pshead%sph_meshsz))
 pawarray%vhtnzcij=zero
 do jlmn=1,pshead%lmn_size
  j0lmn=jlmn*(jlmn-1)/2
  jlm=pawdata%indlmn(4,jlmn);jln=pawdata%indlmn(5,jlmn)
  do ilmn=1,jlmn
   klmn=j0lmn+ilmn
   ilm=pawdata%indlmn(4,ilmn);iln=pawdata%indlmn(5,ilmn)
   if (jlm==ilm) then
    do ir=1,pshead%sph_meshsz
     ff(ir)=pawps%tphi(ir,iln)*pawps%vhtnzc(ir)*pawps%tphi(ir,jln)&
&          *pawdata%rad_(ir)
    enddo
    call ctrap(pshead%sph_meshsz,ff,pshead%log_step,&
&              pawarray%vhtnzcij(klmn))
   endif
  enddo
 enddo
 deallocate(ff)

!
!Test the behaviour of VhtnZc at long range: vhnzc(r)=-Z/r ?
!-----------------------------------------------------------
  write(un_log,'(/,a)') '> USpp->Abinit translator INFO:'
  write(un_log,'(a,i4,a,a,g11.4)') &
&   '  At r_vloc=r(',pshead%vloc_meshsz,'),',&
&   ' VHartree(ntild(Zv+Zc))= -Zv/r + ',&
&     pawps%vhtnzc(pshead%vloc_meshsz) &
&    +pshead%valence_charge/pawdata%rad(pshead%vloc_meshsz)
  write(un_log,'(a)') &
&   '  This quantity must be as small as possible.'

 end subroutine calc_vhtnzc

!!***
