// -*- C++ -*-
// Grid_Client_i.h,v 1.1 1999/07/09 01:40:04 bala Exp

// ============================================================================
//
// = LIBRARY
//    TAO/examples/Simple/grid
//
// = FILENAME
//    Grid_Client_i.h
//
// = DESCRIPTION
//    This class implements the interface calls for RMI.
//
// = AUTHOR
//   Balachandran Natarajan <bala@cs.wustl.edu>
//    
// ============================================================================

#ifndef GRID_CLIENT_I_H
#define GRID_CLIENT_I_H

#include "Simple_util.h"
#include "GridC.h"

class Grid_Client_i
{
  // = TITLE
  //   Grid_Client interface subclass.
  //
  // = DESCRIPTION
  //   This class implements the interface between the interface
  //   objects and the client .
public:
  // = Initialization and termination methods.
  Grid_Client_i (void);
  // Constructor

  virtual ~Grid_Client_i (void);
  // Destructor

  virtual int run (const char *, int, char *[]);
  // Execute the methods.

  virtual int parse_args (int argc, char *argv[]);
  // Parses the command line arguments.

private:
  Client<Grid_Factory, Grid_Factory_var> client;
  // Instantiate the client object.

  CORBA::Short height_;
  // Height of the grid.

  CORBA::Short width_;
  // Width of the grid.

  CORBA::Short setx_;
  // Cell identifier in which a value meeds to be stored.

  CORBA::Short sety_;
  // Cell identifier in which a value meeds to be stored.

  CORBA::Long value_;
  // The value that needs to be stored in the cell.
  
  CORBA::Short repeat_;
  // A flag for testing persistence
};

#endif /* TIME_CLIENT_I_H */
