// -*- C++ -*-
//
// Client_ORBInitializer.cpp,v 1.4 2005/07/20 12:33:23 jwillemsen Exp
//

#include "Client_ORBInitializer.h"
#include "tao/ORBInitializer_Registry.h"

ACE_RCSID (Recursive_ORBInitializer,
           Client_ORBInitializer,
           "Client_ORBInitializer.cpp,v 1.4 2005/07/20 12:33:23 jwillemsen Exp")

Client_ORBInitializer::Client_ORBInitializer (Client_ORBInitializer *second) :
  pre_init_called (0),
  post_init_called (0),
  second_ (second)
{
}

void
Client_ORBInitializer::pre_init (
    PortableInterceptor::ORBInitInfo_ptr
    ACE_ENV_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  ++pre_init_called;

  if (second_ != 0)
    {
      PortableInterceptor::register_orb_initializer (second_
                                                     ACE_ENV_ARG_PARAMETER);
      ACE_CHECK;

      // Registered the initializer, clear the pointer so that we only do it
      // once
      second_ = 0;
    }
}

void
Client_ORBInitializer::post_init (
    PortableInterceptor::ORBInitInfo_ptr
    ACE_ENV_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  ++post_init_called;
}

