//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>. 
void acetoneiso::compress()
{
QDir bin("/usr/bin");
QFile pzip;
QDir::setCurrent( bin.path() );
pzip.setFileName("7z");

if (pzip.exists())
{
 QDir Home = QDir::home();
QString dacomprimere = QFileDialog::getOpenFileName(this,tr("AcetoneISO::Select Image to compress"), Home.path(), tr("Image Files (*.iso *.daa *.bin *.mdf *.ashdisc *.bwi *.b5i *.lcd *.img *.cdi *.cif *.p01 *.pdi *.nrg *.ncd *.pxi *.gi *.fcd *.vcd *.c2d *.gpg)"));
	if (!dacomprimere.isEmpty() )
		{
		 QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save Compressed Image"),
										Home.path() + "/AcetoneISO_Compressed",
										tr("Images (*.7z)"));
		if ( fileName.isNull() ) {
			  return;
		}

		 fileName.append(".7z");
		 
		  disable_all_button_processes();
		 
			QMessageBox msgBox;
			msgBox.setText(tr("Do You want to compress in Ultra High mode? (very slow)"));
			msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
		switch (msgBox.exec()) {
				case QMessageBox::Yes:
					{
					 PZip.start("7z",QStringList() <<  "a" << "-y" << "-t7z" << "-m0=lzma" << "-mx=9" << "-mfb=64" << "-md=32m" << "-ms=on" << fileName << dacomprimere );
					 progBarra();
					}
					break;
				case QMessageBox::No:
					{
					 PZip.start("7z",QStringList() <<  "a" << "-y" << "-t7z" << "-m0=lzma" << "-mx=4" << "-mfb=32" << "-md=4m" << "-ms=on" << fileName << dacomprimere );
					 progBarra();
					}
				break;
				default:
				// should never be reached
				break;
					}
			
			
		}

}
else
QMessageBox::warning(this, "AcetoneISO::Warning!",tr("no 7z found in /usr/bin"));

}

void acetoneiso::uncompress()
{
QDir bin("/usr/bin");
QFile pzip;
QDir::setCurrent( bin.path() );
pzip.setFileName("7z");
if (pzip.exists()){
 QDir Home = QDir::home();
 QString fileName = QFileDialog::getOpenFileName(this,tr("Open Compressed Image"), Home.path() , tr("Image Files (*.7z)"));
 if ( fileName.isNull() ){
 }
 else{
  QDir Home = QDir::home();
  QString uncompress_folder = QFileDialog::getExistingDirectory(this, tr("AcetoneISO::Select Folder where the uncompressed Image will be saved"),Home.path() );
	if ( uncompress_folder.isNull() ){
	}
	else{
		uncompress_folder = uncompress_folder.prepend("-o");
		
		disable_all_button_processes();
		PZipuncompress.start("7z",QStringList()  << "e" << "-y" << fileName << uncompress_folder);
		progBarra();
	    }
      }
   }
else
QMessageBox::warning(this, "AcetoneISO::Warning!",tr("no 7z found in /usr/bin, please install p7zip-full package"));
}




//extract rar password protected feature
void acetoneiso::rar()
{
//unrar x -p123xxx321 -y ok.rar /home/doe/dove_ti_pare
QDir bin("/usr/bin");
QFile rar;
QDir::setCurrent( bin.path() );
rar.setFileName("unrar-nonfree");
if (rar.exists())
{

 QDir Home = QDir::home();
 QString fileName = QFileDialog::getOpenFileName(this,tr("Open RAR password protected"),Home.path() , tr("RAR File (*.rar *.rev *.r00)"));
 if ( fileName.isNull() ) {
    return;
  }

 bool okkk;
QString text3 = QInputDialog::getText(this, tr("AcetoneISO::Insert password"),
tr("Please insert the password of the RAR archive"), QLineEdit::Password, "", &okkk);

  if (okkk && !text3.isEmpty()) {
  QDir Home = QDir::home();
  QString uncompress_folder = QFileDialog::getExistingDirectory(this, tr("AcetoneISO::Select Folder where the uncompressed RAR will be extracted"),Home.path() );
	if ( uncompress_folder.isNull() ){
	  return;
	}

	QString file;
	file = text3.prepend("-p");

	 showProgressDisplay();
	 RAR = new QProcess();
	 RAR->setReadChannel(QProcess::StandardOutput);
	 RAR->setProcessChannelMode(QProcess::MergedChannels);	
 	//connection to update the display
 	connect(RAR, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_RAR() )); 
	connect(RAR, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOutRAR(int, QProcess::ExitStatus)));  
		RAR->start("unrar-nonfree",QStringList()  << "x" << file << "-y" << fileName << uncompress_folder);


}



}
else
QMessageBox::warning(this, "AcetoneISO::Warning!",tr("no unrar-nonfree found in /usr/bin. Please install unrar-nonfree package."));
}



/*

QUESTO CODICE FUNZIONA, PECCATO CHE IL FILE GENERATO NON FUNZIONA CON LA PSP!

//iso 2 cso for Sony PSP (what? custom firmware?! :DDDDDDD go go Dark Alex!)
void acetoneiso::cso()
{
//ciso 9 infile.iso outfile.cso
QDir bin("/usr/bin");
QFile cso;
QDir::setCurrent( bin.path() );
cso.setFileName("ciso");
if (cso.exists())
{

 QDir Home = QDir::home();
 QString fileName = QFileDialog::getOpenFileName(this,tr("ISO PSP game"),Home.path() , tr("ISO File (*.iso)"));
 if ( fileName.isNull() ) {
    return;
  }
 else{

		 QString filesave = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save Compressed PSP Game"),
										Home.path() + "/AcetoneISO_PSP_Game_Compressed",
										tr("CSO (*.cso)"));
		if ( filesave.isNull() )
			{
			}
			else
			{
		 filesave.append(".cso");
	PZipuncompress.start("ciso",QStringList()  << "9" << fileName << filesave);
		progBarra();

}

}

}
else
QMessageBox::warning(this, "AcetoneISO::Warning!",tr("no ciso found in /usr/bin. Please install ciso package."));
}


//da cso a iso
void acetoneiso::cso2iso()
{

//ciso 0 infile.iso outfile.cso
QDir bin("/usr/bin");
QFile cso;
QDir::setCurrent( bin.path() );
cso.setFileName("ciso");
if (cso.exists())
{

 QDir Home = QDir::home();
 QString fileName = QFileDialog::getOpenFileName(this,tr("CSO PSP game"),Home.path() , tr("CSO File (*.cso)"));
 if ( fileName.isNull() ) {
    return;
  }
 else{

		 QString filesave = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save extracted ISO PSP Game"),
										Home.path() + "/AcetoneISO_PSP_ISO",
										tr("ISO (*.iso)"));
		if ( filesave.isNull() )
			{
			}
			else
			{
		 filesave.append(".iso");
	PZipuncompress.start("ciso",QStringList()  << "0" << fileName << filesave);
		progBarra();

}

}

}
else
QMessageBox::warning(this, "AcetoneISO::Warning!",tr("no ciso found in /usr/bin. Please install ciso package."));

}

*/


