;;; EMAIL-DECRYPT
;;; -------------

(defun decrypt-headers (headers key )
  (if (endp headers)
      nil
    (let* ((header  (car headers))
	   (field   (car header))
	   (content (cdr header)))
      (cond ((equal 'subject field)
	     (cons (cons field (unwrap-list content (list 'encrypted key)))
		   (decrypt-headers (cdr headers) key)))
	     (t (cons header 
		      (decrypt-headers (cdr headers) key )))))))

(defthm unwrap-list-undoes-wrap-list
  (implies
   (equal key unkey)
  (equal
   (unwrap-list (wrap-list lst key) unkey)
   lst)))

(in-theory (enable unwrap-list wrap-list))

(defthm decrypt-headers-undoes-encrypt-headers
 (implies
  (and
   (symbol-alistp headers)
   )
  (equal
   (decrypt-headers
    (encrypt-headers headers key)
    key)
   headers)))

(defun decrypt-body (body key)
 (unwrap-list body (list 'encrypted key)))

(defun decrypt-message (msg key)
  (update-message msg
   :headers (decrypt-headers (message-headers msg) key)
   :body    (decrypt-body    (message-body    msg) key)))

(defthm body-encrypted-by-encrypt-body
 (implies
  (and
   body
   )
  (body-encrypted? (encrypt-body body key))))


(fif comment
(thm ;defthm body-encrypted-by-encrypt-body
 (implies
  (and
   (message-p msg)
   key
   nonce
   )
   (encrypt-message msg key nonce)))
)

(fif comment
(thm
 (implies
  (and
   (message-p msg)
   )
  (equal
   (decrypt-message
    (encrypt-message msg key nonce)
    key)
   msg)))
)

(defun invalid-decrypt-message-result (msg)
  (if (endp msg) nil
    (if (equal 'encrypted
	       (cadr msg))
	t
      (invalid-decrypt-message-result (cdr msg)))))

(defun email-decrypt-init (env)
  (set-var 'user '()
  (set-var 'own-key '() env)))

(defun email-decrypt-command (cmd args env)
   (cond ((equal 'SET_USER cmd)
	  (let ((?user (nth 0 args)))
	    (set-var 'user ?user env)))
	 ((equal 'SET_OWN_KEY cmd)
	  (let ((key (nth 0 args)))
	    (set-var 'own-key key env)))
	 (t env)))

(defun email-decrypt-outgoing (msg env)
   (act comment "[Outgoing events not handled"))

(defun email-decrypt-incoming (msg env)
  (let ((?user (LOOKUP 'user))
	(?ok   (LOOKUP 'own-key)))
    (if (equal "" ?user)
	(act comment "[No user set --> message discarded]")
      (if (equal ?ok "")
	  (act deliver msg env)
	(let ((?dmsg (DECRYPT-MESSAGE msg ?ok)))
	  (if (invalid-decrypt-message-result ?dmsg)
	      (act deliver msg env)
	    (act deliver ?dmsg env)))))))
