/*
 *  ACM - Drawing utilities
 *  Copyright (C) 2007  Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * This module implements some drawing procedures based on the Vlib
 * module. The main difference is that floating point numbers are used
 * instead of integer numbers, and the list of segments gets allocated
 * dynamically.
 * 
 * Every path, once generated, can be draw on the screen several times, in
 * different positions and with some transformation.
 */

#ifndef _DRAW_H
#define _DRAW_H

#include "../V/Vlib.h"

#ifdef draw_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

typedef struct draw_Type draw_Type;

/**
 * Returns a new, empty path. Can be released with draw_free() or disposed off
 * with memory_dispose().
 * @return 
 */
EXTERN draw_Type * draw_new(void);

/**
 * Releases a path which is not going to be used anymore. Released paths are
 * saved in a spare list to be reused later.
 * @param dd
 */
EXTERN void draw_free(draw_Type *dd);

EXTERN void draw_segment(draw_Type *dd, double x1, double y1, double x2, double y2);

EXTERN void draw_rect(draw_Type *dd, double x1, double y1, double x2, double y2);

EXTERN void draw_circle(draw_Type *dd, double xo, double yo, double r);

EXTERN void draw_arc(draw_Type *dd, double xo, double yo, double r, double a1, double a2);

/**
 * Creates a pointer of length l with pivot at (xo,yo) and rotated 'a' RAD.
 * a=0 means the pointer is oriented toward right, and it rotates
 * clockwise on the screen.
 */
EXTERN void draw_pointer(draw_Type *dd, double xo, double yo, double a, double l);

/** Send draw data to the specified viewport using the specified color */
EXTERN void draw_stroke(draw_Type *dd, Viewport *v, Alib_Pixel color);

/** FIXME: it does not work yet */
EXTERN void draw_fill(draw_Type *dd, Viewport *v, Alib_Pixel color);

EXTERN void draw_string_centered(Viewport *v, double xo, double yo, double fh,
	char *s, Alib_Pixel color);

#undef EXTERN
#endif /* _DRAW_H */
