#    
# Module:     readline.pm   
# Date:       03/05/04   
# Version:    1.17   
# Edited by:  teon@teon.org   
# Description:   
# 
#  This is a readline based User Interface.
#   
# License:   
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
#
# Copyright (C) 2003-2004 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003-2004 Robert Olejnik <teon@teon.org>
#

package AddUser::UI::readline;

use strict;
use Term::ANSIColor qw(:constants);
use Term::ReadLine;



sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	bless \%args, $class;
}

# init
# 
# Initialize UI
#
# {{{
sub init
{
	my $self = shift;
	$self->{term} = new Term::ReadLine::Gnu 'AddUser-NG';

	$| = 1;
}

# }}}


# end
# 
# Cleanup
#
# {{{
sub end
{
        # nothing to do for this UI
}

# }}}

# display($title, $msg)
#
# Display a message.
#
# {{{
sub display
{
        my ($self, $title, $msg) = @_;
        
        print "\n", BOLD, BLUE, "-=[", YELLOW, " $title ", BLUE, "]=-", RESET, "\n\n";
        print "$msg\n";

}

# }}}

# display_getkey($title, $msg)
#
# Same as 'display', but it wait's for user to hit anykey [TM]
#
# {{{
sub display_getkey
{
        my ($self, $title, $msg) = @_;
        
        print "\n", BOLD, BLUE, "-=[", YELLOW, " $title ", BLUE, "]=-", RESET, "\n\n";
        print "$msg\n";
        <STDIN>;

}

# }}}

# display_error($title, $msg)
#
# Display an error message.
#
# {{{
sub display_error
{
        my ($self, $title, $msg) = @_;
        
        print "\n", BOLD, BLUE, "-=[", RED, " $title ", BLUE, "]=-", RESET, "\n\n";
        print "$msg\n";

}

# }}}

# get_single($plugname, $optname, $short, $desc, $def, @answers)
#
# {{{
sub get_single {
	my ($self, $plugname, $optname, $short, $desc, $def, @answers) = @_;
	my $ans;
	my $correct = join ", ", @answers;

	use Text::Wrap;
	$desc = wrap('', '', $desc);

	print "\n", GREEN, "$plugname/$optname -- $short", RESET, "\n";
	print "\n$desc\n\n";
	while (1) {
		chomp($ans = $self->{term}->readline("$optname ($correct)> ", $def));
		#$key =~ s/^[$ans]$/i;
		$ans = lc $ans;
		last if grep { $_ eq $ans } @answers;
		print "\tIncorrect answer. Choose one of: $correct.\n\n";
	}

	return $ans;
}
# }}}

# get_long($plugin, $option, $synopsis, $description, $default)
#
# {{{
sub get_long {
	my ($self, $plugname, $optname, $short, $desc, $def) = @_;
	my $ans;

	use Text::Wrap;
	$desc = wrap('', '', $desc);

	print "\n", GREEN, "$plugname/$optname -- $short", RESET, "\n";
	print "\n$desc\n\n";

	$ans = $self->{term}->readline("$optname> ", $def);
	if (not defined $ans) {
		$ans = $def;
	}

	return ($ans ne "") ? $ans : $def;
}
# }}}

# get_password($plugin, $option, $synopsis, $description, $default)
#
# {{{
sub get_password {
	my ($self, $plugname, $optname, $short, $desc, $def) = @_;
	my $ans;

	use Text::Wrap;
	$desc = wrap('', '', $desc);

	print "\n", GREEN, "$plugname/$optname -- $short", RESET, "\n";
	print "\n$desc\n\n";

	my $attr = $self->{term}->Attribs;
	my $rf = $attr->{redisplay_function};
	$attr->{redisplay_function} = $attr->{shadow_redisplay};
	$ans = $self->{term}->readline("$optname> ", $def);
	$attr->{redisplay_function} = $rf;
	if (not defined $ans) {
		$ans = $def;
	}

	return ($ans ne "") ? $ans : $def;
}
# }}}

1;
