/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef ADUN_NONBONDED_LISTHANDLER_
#define ADUN_NONBONDED_LISTHANDLER_

#include "Base/AdVector.h"
#include "Base/AdLinkedList.h"
#include "Base/InterTable.h"
#include "AdunKernel/AdunDefinitions.h"
#include "AdunKernel/AdunObject.h"
#include "AdunKernel/AdunLinkedList.h"

/**
\ingroup Inter
\todo The listhandler should either use an specialised init 
e.g. initWithEnvironment:coordinates:topology:parameters
or pass these when creating the lists createListForCoordinates:topology:parameters
The first seems better. Currently you have to initialise, then set the values, then
create which defeats the purpose on initialise...
Or use dataSource...
\todo Since AdNonBondedTopology resets all its listHandlers data on unarchiving
the initWithCoder methods of AdNonbondedListHandler object do nothing more than
return a normal freshly initialised instance. This seems to defeat the purpose
of encoding. Need to look at AdNonbondedTopology encoding/decoding and fix this
\todo ListHandlers should be able to create lists inside or outside the specified cutoff
\todo Could also implement a method that returns a subset of the list matching a certain criteria?
Although this would have to be an array and then you would need to create different functions for lists or array
\todo Allow None for cutoff
*/


@interface AdNonBondedListHandler: AdObject <AdAbstractFactory>
{
	//variables for LinkedList Memory
	int block_count;	//the current location in the current block
	int block_no;		//the current number of blocks
	int current_block_no; 	//the number of the current block
	int freedElementsCount;
	ListElement* blocks[50];	//array containing the current blocks
	ListElement* current_block;	//the current block
	ListElement* freedElementsList; //the start of the freed ListElements list
	ListElement* freeElementsEnd; 	//the end of the freed ListElements list
}

- (void) createList;
- (void) update;
- (void) setCutoff: (int) aValue;
- (void) setCoordinates: (NSValue*) aValue;
- (void) setNonbondedTopology: (NSArray*) anArray;
- (void) setParameters: (NSValue*) aValue;
- (NSValue*) nonbondedInteractions;
- (int) numberNonbondedInteractions;

@end

#endif

