/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include <ShiftedNonBondedCalculator.h>

@implementation ShiftedNonBondedCalculator

- (void) evaluateForces;
{
	ListElement* list_p;

	estPotential = 0;
	vdwPotential = 0;
	
	/**
	\note May be quicker to get the number of nonbonded interactions and then use a for loop here
	**/

	list_p = interactionList->next;
  	while(list_p->next != NULL)
  	{
  		AdEnzymixShiftedNonbondedForce(list_p, &vdwPotential, &estPotential,
				permittivity, coordinates->matrix, forces->matrix, cutoff, r_cutoff2);
 		list_p = list_p->next;
  	}
}

- (void) evaluateTypeOneVDWForces
{
	NSLog(@"Method (%@) not implemented", NSStringFromSelector(_cmd));
}

- (void) evaluateElectostaticForces
{
	NSLog(@"Method (%@) not implemented", NSStringFromSelector(_cmd));
}

- (void) evaluatePotential;
{
	ListElement* list_p;
	
	estPotential = 0;
	vdwPotential = 0;

	list_p = interactionList->next;
  	while(list_p->next != NULL)
  	{
  		AdEnzymixShiftedNonbondedEnergy(list_p, &vdwPotential, &estPotential,
				permittivity, coordinates->matrix, cutoff, r_cutoff2);
 		list_p = list_p->next;
  	}
}

/**Object Creation and Maintenance**/

- (id) init
{
	return [self initWithEnvironment: nil];
}

- (void) _initialiseDependants
{
	r_cutoff2 = 1/(cutoff*cutoff);
}

- (id) initWithEnvironment: (id) object
{
	return [self initWithEnvironment: object observe: YES];
}

- (id) initWithEnvironment: (id) object observe: (BOOL) value
{
	if(self = [super initWithEnvironment: object observe: value])
	{
		forces = NULL;
		coordinates = NULL;
		if(environment == nil)
		{
			cutoff = 12;
			permittivity = PI4EP_R;
		}
		else
		{
			cutoff = [[environment valueForKey: @"CutOff"] floatValue];
			permittivity = (1/[[environment valueForKey: @"Permittivity"] doubleValue])*PI4EP_R;
		}

		[self _initialiseDependants];
	}	

	return self;
}

- (void) dealloc
{
	[super dealloc];
}

/**Accessors**/

- (void) setInteractions: (NSValue*) NonbondedInteractionLists;
{	
	interactionList = (ListElement*)[NonbondedInteractionLists pointerValue];
}

- (void) setCoordinates: (NSValue*) value
{
	coordinates = [value pointerValue];
}

- (void) useExternalForceMatrix: (AdMatrix*) matrix
{
	forces = matrix;
}

- (double) ElectrostaticPotential
{
	return estPotential;
}

- (double) VDWPotential
{
	return vdwPotential;
}

- (void) setCutOff: (NSNumber*) aNumber
{
	cutoff = [aNumber floatValue];
} 

@end
