/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef AD_UPDATING
#define AD_UPDATING
#include <Foundation/Foundation.h>

/**
Any object whose internal state changes depending on the value of certain variables
e.g the time should implement this protocol.
\ingroup Protocols
**/

@protocol AdUpdating
/**
Statically updates the state of the object. The implementation
performs update events that do not involve time (sometimes conditonal on the value of
certain variables etc) **/
- (void) update;
@end

@protocol AdFrameUpdating
/**
Updates the state of a system object performing any events associated 
with time (interaction updates, write outs etc) aswell as static event. Afterwards the system
represents a new frame in a trajectory
**/
- (void) frameUpdate;

@end

/**
The AdMemento Protocol defines an interface for objects, whose state changes, to provide the ability
to recreate themselves in a previous or later state. 
\ingroup Protocols
*/

@protocol AdMemento

/**
Sets the options that dictate what information the object will include in a memento
Also affects what information is encoded by encodeWithCoder:
The available methods depend on the particular object implementing the protocol
*/

- (id) setCaptureMethod: (NSString*) name;

/**
Encodes a memento of the object which is added to the archive in encoder
with key \e key. encoder must supported keyed archiving. This object can
later be used unarchived and used with returnToState:
*/

- (void) captureStateWithArchiver: (NSCoder*) encoder key: (NSString*) key;

/**
Returns the reciever to the state encapsulated by stateMemento.
*/

- (void) returnToState: (id) stateMemento;

/**
Returns an object that encapsulates the current state of the object.
The type of the object can vary from class to class i.e. it may
be an NSData object or a special class etc. This object can then
be used as the arguement to returnToState:. Since the type of the object
is unknown, and could already be archived data, you should not encode
it directly in an archive. Instead use captureStateWithArchiver:key to do
this.
*/
- (id) captureState;
@end

#endif
