/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-07-14 13:34:47 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULINTERACTIONSBUILDER_H_
#define _ULINTERACTIONSBUILDER_H_

#include <Foundation/Foundation.h>
#include <ULSystem.h>
#include "ULMatrix.h"
#include "XMLLib/XMLLib.h"


/**
Class to generate the interaction lists from a system.
At the moment we this class assumes we are building using Enzymix.
This is because we have no definitive FFML spec to use.
Once we have this ULInteractionsBuilder will undergo some
radical changes.
\ingroup builder
*/

@interface ULInteractionsBuilder : NSObject
{
	id parameterLibrary;	//!< An adun paramater library mapped into memory as an XML document tree	
	NSMutableString* buildString;
	NSMutableString* errorString;
	FILE* buildOutput;
}

- (id) initWithParameterLibrary: (NSString*) libraryName;
- (void) buildInteractionsForSystem: (ULSystem*) system
		error: (NSError**) buildError
		userInfo: (NSString**) userInfo;

@end

#endif // _ULINTERACTIONSBUILDER_H_

