/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <addressclass.h>
#include <addressbookview.h>
#include <ataddressbook.h>

#include <stdio.h>

#include <kiconloader.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qcstring.h>
#include <qstring.h>
#include <qheader.h>

#define IDSTRING "AddressBookView: "


// #define DEBUG_ABW


AddressBookView::AddressBookView( QWidget *parent, const char *name):QListView(parent, name)
{
	setSelectionMode(QListView::Extended);
	addColumn("Names");
	addColumn("E-mail");
//	header()->hide();
	setSorting(-1);
	setRootIsDecorated(true);
	setAllColumnsShowFocus(true);
}
void AddressBookView::initMode(int mode, QString match, bool showMatched)
{
	AddressBook *instance=AddressBook::thisInstance();
	QStringList list;
	bool _show=true;
	// UI - showing the header..?
	if(mode & AddressBook::ShowHeader)
		header()->show();
	else
		header()->hide();
	// UI - as list? as tree?
	setRootIsDecorated(!(mode & AddressBook::ListOnly));
	if(mode & AddressBook::Groups)
	{
		list=instance->completeNames("", AddressBook::Groups);
		for(int i=0;i<list.count();i++)
		{
			if(match==QString::null)
			{
				_show=true;
			}
			else
			{
				if (showMatched)
					if(isMatched(instance->getEntry(list[i]),match))
						_show=true;
					else
						_show=false;
				else
					if(!isMatched(instance->getEntry(list[i]),match))
						_show=true;
					else
						_show=false;
			}
			if(_show)
			{
				QListViewItem *item=new QListViewItem(this);
				//QCheckListItem *item=new QCheckListItem(this, "test");
				item->setText(0,list[i]);
				item->setPixmap(0,BarIcon("Groups"));
				item->setText(2,instance->getEntry(list[i]).join(","));
				insertItem(item);
				QStringList members=instance->getEntry(list[i]);
				if(members.count()==0 || (mode & AddressBook::ListOnly))
					item->setExpandable(false);
				else
					item->setExpandable(true);
				for(int i=0;i<members.count() && (!(mode & AddressBook::ListOnly));i++)
				{
					QListViewItem *subItem=new QListViewItem(item);
					QCString _tmp_=(const char *)members[i];
					AddressClass *ac=new AddressClass(_tmp_);
					if(ac->translated_name.isEmpty())
						delete subItem;
					else
					{
						subItem->setText(0,(const char *)ac->translated_name);
						subItem->setText(1,(const char *)ac->email);
						subItem->setText(2,(const char *)members[i]);
						subItem->setPixmap(0,BarIcon("Contacts"));
	//					insertItem(subItem);
					}
					delete ac;
				}
			}
		}
	}
//	return;
	if(mode & AddressBook::Contacts)
	{
		// here is a list containing all the unique names...
		QStringList uniq;
		QString elem;
		list=instance->completeNames("", AddressBook::Contacts);
		for(int i=0;i<list.count();i++)
		{
			elem=instance->getDefaultName(list[i]);
			if(uniq.findIndex(elem)==-1) uniq.append(elem);
		}
		list=uniq;
#ifdef DEBUG_ABW
		for(int i=0;i<list.count();i++)
			printf(IDSTRING" Element : %s\n",(const char *)list[i]);
#endif
		list=instance->getEntries(list);
#ifdef DEBUG_ABW
		for(int i=0;i<list.count();i++)
			printf(IDSTRING" Element (2): %s\n",(const char *)list[i]);
		printf("Contacts: %d\n", list.count());
#endif
		for(int i=0;i<list.count();i++)
		{
			QListViewItem *item=new QListViewItem(this);
			QStringList l=QStringList::split(',',list[i]);
#ifdef DEBUG_ABW
			printf(IDSTRING" Elements: %d\n",l.count());
#endif
			if(l.count()<=1)
				item->setExpandable(false);
			else
				item->setExpandable(true);
			QCString cstr=(const char *)l[0];
			AddressClass *ac=new AddressClass(cstr);
			if(ac->translated_name.simplifyWhiteSpace().isEmpty())
				delete item;
			else
			{
				item->setText(0,(const char *)ac->translated_name);
				item->setText(1,(const char *)ac->email);
				item->setText(2,(const char *)l[0]);
				item->setPixmap(0,BarIcon("Contacts"));
				insertItem(item);
			}
			delete ac;
			if(l.count()>1)
				for(int j=1;j<l.count();j++)
				{
					QListViewItem *subItem=new QListViewItem(item);
					QCString _tmp_=(const char *)l[j];
					AddressClass *ac=new AddressClass(_tmp_);
					if(ac->translated_name.isEmpty())
						delete subItem;
					else
					{
						subItem->setText(0,(const char *)ac->translated_name);
						subItem->setText(1,(const char *)ac->email);
						subItem->setText(2,(const char *)l[j]);
						subItem->setPixmap(0,BarIcon("Contacts"));
	//					insertItem(subItem);
					}
					delete ac;
				}
		}
	}
	if(mode & AddressBook::History)
	{
		list=instance->completeNames("", AddressBook::History);
#ifdef DEBUG_ABW
		printf("History: %d\n", list.count());
#endif
		for(int i=0;i<list.count();i++)
		{
			QListViewItem *item=new QListViewItem(this);
			item->setText(0,list[i]);
			item->setPixmap(0,BarIcon("Contacts"));
			insertItem(item);
		}
	}
}
void AddressBookView::getSelectedEmailList(QStringList &list)
{
	list.clear();
	QListViewItemIterator it(this);
	for ( ; it.current(); ++it )
	{
		if (it.current()->isSelected() && !it.current()->text(0).isEmpty())
		{
			list+=QStringList::split(',',it.current()->text(2));
		}
	}
}

bool AddressBookView::isMatched(QStringList l, QString check)
{
	AddressClass *checkAc = new AddressClass((const char *)check.lower());
	bool result=false;
	for(int i=0;i<l.count();i++)
	{
		AddressClass *ac= new AddressClass((const char *)l[i]);
		result = 	ac->translated_name.lower()==checkAc->translated_name.lower() ||
							ac->email.lower()==checkAc->translated_name.lower();
		delete ac;
		if(result)
		{
			delete checkAc;
			return result;
		}
	}
	delete checkAc;
	return result;
}
