#ifndef __MIMECodec__
#define __MIMECodec__

#include <qcstring.h>

namespace MIMECodec
{
	/** wrap a text without CR-LF chars on the 76 character boundary.*/
	QCString canonicalForm(const QCString &);
	
	/** translate a MIME-encoded text.*/
	QCString translate(const QCString &);
	
	/** MIME-fold text (used for headers).*/
	QCString fold(const QCString &);
	
	/** unfold MIME-folded text.*/
	QCString unfold(const QCString &);
	
	/** encode UNIX text (cr-ended) into MIME text (crlf-ended).*/
	QCString encodeEndLine(const QCString &);
	
	/** decode MIME text (crlf-ended) into UNIX text (cr-ended).*/
	QCString decodeEndLine(const QCString &);
	
	/** encode text in quoted-printable format (the bool parameter forces extra MIME gateway compatibility).*/
	QCString encodeQuotedPrintable(const QCString &, bool compat=false);
	
	/** decode quoted-printable encoded text.*/
	QCString decodeQuotedPrintable(const QCString &);
	
	/** encode binary data in base64 format.*/
	QByteArray encodeBase64(const QByteArray &);
	
	/** decode base64-encoded binary data.*/
	QByteArray decodeBase64(const QByteArray &);
	
	/** encode binary data using the given encoding name ("base64", "quoted-printable", "7bit", "8bit", "binary", "none", "quoted-printable-compat" <- this can be used only for encoding).*/
	QByteArray encode(const QByteArray &, const char *);   // buffer, encoding
	
	/** decode binary data using encoding name.*/
	QByteArray decode(const QByteArray &, const char *); // encoded buffer, encoding
	
	/** encode the message id.
	  * It has a unique number/string and the user name like parameter.
	  */
	QString encodeMessageId(const QString &, const QString &);
};

#endif
