/**
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Variable__
#define __Variable__

#include <qstring.h>

/***
*	Variable
* @short Class for storing a variable's characteristics.
*/
class Variable
{
	QString name;
	QString value;
	QString type;
	bool input;
public:
	/** 
	 *   Constructor
	 * @param n the variable's name
	 * @param v the variable's value
	 * @param t the variable's type
	 */
	Variable(QString n=QString::null, 
		QString v=QString::null,
		QString t=QString::null);
	/** 
	 *   Method for accessing the variable's fields.
	 * @return the variable's name.
	 */
	QString getName()	{ return name; }
	/** 
	 *   Method for accessing the variable's fields.
	 * @return the variable's value.
	 */
	QString getValue() { return value; }
	/** 
	 *   Method for accessing the variable's fields.
	 * @return the variable's type.
	 */
	QString getType() { return type; }
	/** 
	 *   Method for accessing the variable's fields.
	 * @return true if the variable has to be refreshed by the user. False
	 * otherwise
	 */
	bool getInput() { return input; }
	/** 
	 *   Method for accessing the variable's fields.
	 * @param newName the variable's new name.
	 */
	void setName(QString newName) { name=newName; }
	/** 
	 *   Method for accessing the variable's fields.
	 * @param newValue the variable's new value.
	 */
	void setValue(QString newValue) { value=newValue; }
	/** 
	 *   Method for accessing the variable's fields.
	 * @param newType the variable's new type.
	 */
	void setType(QString newType) { type=newType; }
	/** 
	 *   Method for accessing the variable's fields.
	 * @param newInput the variable's new input.
	 */
	void setInput(bool newInput) { input=newInput; }
	/** 
	 *   Method for testing if a variable matches some criteria.
	 * @param testName the variable's desired name.
	 * @param testType the variable's desired type.
	 * @param testValue the variable's desired value.
	 * @return true if the variable's fields matches the parameters.
	 * A NULL field is ignored. The name *HAS* to be not void. If the name is
	 * NULL, the function returns FALSE.
	 */
	bool match(QString testName=QString::null, 
		QString testType=QString::null, 
		QString testValue=QString::null);
};

#endif
