/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */


#ifndef _Has_PixLibrary__
#define _Has_PixLibrary__

#include <qintdict.h>
#include <qpixmap.h>

class PixLibrary
{
	public:
		// simple stuff
		enum { SaveIcon=0x00000001,
			NewIcon=0x00000002,
			PrintIcon=0x00000003,
			SendMailIcon=0x00000004,
			GroupIcon=0x00000005,
			BlankIcon=0x00000006,
			OkIcon=0x00000007,
			CancelIcon=0x00000008
		};
		// arrows and help
		enum {
			ArrowUpFocusIcon=0x00000100,
			ArrowUpNormalIcon=0x00000101,
			ArrowDownFocusIcon=0x00000102,
			ArrowDownNormalIcon=0x00000103,
			HelpFocusIcon=0x00000104,
			HelpNormalIcon=0x00000105
		};
		// tree icons
		enum {
			TreeContactsIcon 				= 0x00000200,
			TreeDeletedMessagesIcon = 0x00000201,
			TreeDocumentsIcon 			= 0x00000202,
			TreeDraftsIcon 					= 0x00000203,
			TreeGroupsIcon 					= 0x00000204,
			TreeInboxIcon 					= 0x00000205,
			TreeJournalIcon 				= 0x00000206,
			TreeMagellanIcon 				= 0x00000207,
			TreeMailContainerIcon 	= 0x00000208,
			TreeMailFolderIcon 			= 0x00000209,
			TreeNotesIcon 					= 0x0000020a,
			TreeOutboxIcon 					= 0x0000020b,
			TreePersonalIcon 				= 0x0000020c,
			TreeProjectsIcon 				= 0x0000020d,
			TreeSavedMessagesIcon 	= 0x0000020e,
			TreeSchedulerIcon 			= 0x0000020f,
			TreeScriptIcon 					= 0x00000210,
			TreeSentMailIcon 				= 0x00000211,
			TreeTasksIcon 					= 0x00000212,
			TreeTemplatesIcon 			= 0x00000213,
			TreeTrashIcon 					= 0x00000214,
			TreeWebIcon 						= 0x00000215
		};
		
		//the MailListView
		enum {
			MailAttachmentIcon 			= 0x00000300,
			MailHigherIcon 					= 0x00000301,
			MailHighestIcon 				= 0x00000302,
			MailLowerIcon 					= 0x00000303,
			MailLowestIcon 					= 0x00000304,
			MailNewForwardReplyIcon = 0x00000305,
			MailNewForwardIcon 			= 0x00000306,
			MailNewNormalIcon 			= 0x00000307,
			MailNewReplyIcon 				= 0x00000308,
			MailNormalIcon 					= 0x00000309,
			MailOldForwardReplyIcon = 0x0000030a,
			MailOldForwardIcon 			= 0x0000030b,
			MailOldNormalIcon 			= 0x0000030c,
			MailOldReplyIcon 				= 0x0000030d
		};
		
		// ccenter
		enum {
			CCenterABActiveIcon						= 0x00000400,
			CCenterABNormalIcon						= 0x00000401,
			CCenterMailActiveIcon					= 0x00000402,
			CCenterMailNormalIcon					= 0x00000403,
			CCenterViewActiveIcon					= 0x00000404,
			CCenterViewNormalIcon					= 0x00000405,
			CCenterOtherActiveIcon				= 0x00000406,
			CCenterOtherNormalIcon				= 0x00000407,
			// the buttons
			CCenterAccountsNormalIcon			= 0x00000408,
			CCenterAccountsActiveIcon			= 0x00000409,
			CCenterComposerNormalIcon			= 0x0000040a,
			CCenterComposerActiveIcon			= 0x0000040b,
			CCenterContactsNormalIcon			= 0x0000040c,
			CCenterContactsActiveIcon			= 0x0000040d,
			CCenterFormatOptNormalIcon		= 0x0000040e,
			CCenterFormatOptActiveIcon		= 0x0000040f,
			CCenterGroupsNormalIcon				= 0x00000410,
			CCenterGroupsActiveIcon				= 0x00000411,
			CCenterMailOptNormalIcon			= 0x00000412,
			CCenterMailOptActiveIcon			= 0x00000413,
			CCenterNotesNormalIcon				= 0x00000414,
			CCenterNotesActiveIcon				= 0x00000415,
			CCenterOtherOptNormalIcon			= 0x00000416,
			CCenterOtherOptActiveIcon			= 0x00000417,
			CCenterSROptNormalIcon				= 0x00000418,
			CCenterSROptActiveIcon				= 0x00000419,
			CCenterViewOptNormalIcon			= 0x0000041a,
			CCenterViewOptActiveIcon			= 0x0000041b
		};
		
		// icons for folders & the M (small) icon
		enum
		{
			MagellanIcon = 0xffffffff
		};
	public:
		PixLibrary();
		QPixmap &pixmap(int identifier);
		static PixLibrary *thisInstance();
	private:
		void load();
		QIntDict<QPixmap> buffer;
		static PixLibrary *pixLibInstance;
};

#endif
