/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Has_PersonalWidget__
#define __Has_PersonalWidget__

#include <personalwidgetbase.h>
#include <cardclasses.h>

class PersonalWidget : public PersonalWidgetBase
{
	Q_OBJECT
	public:
		PersonalWidget (CardPersonalElements *elements, QWidget *parent=0, const char *name=0);
		CardPersonalElements *items();
		void setItems(CardPersonalElements *);

	public:
		QString nameToCard(QString);
		QString cardToName(QString);
	public slots:
    void adrCityChanged(const QString &);
    void adrCodeChanged(const QString &);
    void adrCountryChanged(const QString &);
    void adrDetailsChanged(const QString &);
    void adrPoBoxChanged(const QString &);
    void adrStreetChanged(const QString &);
    void cardChanged(const QString &);
    void familyChanged(const QString &);
    void nameChanged(const QString &);
    void urlChanged(const QString &);
    void nickChanged(const QString &);
    void prefixChanged(const QString &);
    void initialChanged(const QString &);
		void clearUrl();
    void showEmails();
    void showHomePhones();
		void urlUpdated(const QStringList &);
	signals:
		void urlUpdatedSignal(const QStringList &);
		void changedSignal();
	private:
		CardPersonalElements *_items;
};

#endif
