/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/** Changed by Eugen C. - 04 July 2001 */

#include <qlist.h>
#include <templateview.h>
#include <brokeriface.h>
#include <qdragobject.h>
#include <qstrlist.h>
#include <clipboard.h>
#include <qmessagebox.h>
#include <maillistview.h>
#include <clientrmi.h>
#include <contentswidget.h>
#include <destinationdialog.h>
#include <clientvfs.h>
#include <foldertreeitem.h>
#include <datahandlerimpl.h>

DataHandlerImpl::DataHandlerImpl():DataHandler()
{
}

int DataHandlerImpl::copySelection()
{
	QList<DataWidget> selectedViews=getSelection();
	QStrList uriList;
	TemplateView *tw;
	
	for(QListIterator<DataWidget> it(selectedViews); it.current(); ++it)
	{
		tw=dynamic_cast<TemplateView *>((*it));
		if(tw)
		  uriList.append((const char *)tw->path());
	}
	
	if(uriList.count())
		return ClipboardWrapper::thisInstance()->copyData(new QUriDrag(uriList));
	else
		return -1;
}

int DataHandlerImpl::cutSelection()
{
	QList<DataWidget> selectedViews=getSelection();
	QStrList uriList;
	TemplateView *tw;
	
	for(QListIterator<DataWidget> it(selectedViews); it.current(); ++it)
	{
		tw=dynamic_cast<TemplateView *>((*it));
		if(tw)
		  uriList.append((const char *)tw->path());
	}
	
	if(uriList.count())
	{
		DataHandler::grayOutSelection();
		return ClipboardWrapper::thisInstance()->cutData(new QUriDrag(uriList));
	}
	else
		return -1;
}

void DataHandlerImpl::deleteSelection()
{
	QList<DataWidget> selectedViews=getSelection();
	TemplateView *t;
	bool setExpungeMode=false;
	
	if(dynamic_cast<MailListView *>(this) && selectedViews.count()>1)
	  setExpungeMode=true;
	
	if(setExpungeMode)
	  ClientRMI::ref()->setAutoExpunge(false);
	
	for(QListIterator<DataWidget> it(selectedViews); it.current(); ++it)
	{
		t=dynamic_cast<TemplateView *>((*it));
		if( t )
		{
		  if( it.atLast() && setExpungeMode )
	      ClientRMI::ref()->setAutoExpunge(true);
		  BrokerInterface::thisInstance()->remove(t->path());
		}
	}
}

void DataHandlerImpl::openSelection()
{
	QList<DataWidget> selectedViews=getSelection();
	
	if (selectedViews.count()>PROGRESS_THRESHOLD)
	{
		if(QMessageBox::warning(0, "Confirm open", "You have selected a large number of items.\nOpening them could take a significant amount of time.\nAre you sure you want to open them?", QMessageBox::Yes, QMessageBox::No)==QMessageBox::Yes)
		{
	    for(QListIterator<DataWidget> it(selectedViews); it.current(); ++it)
				(*it)->open();
		}
	}
}

void DataHandlerImpl::sendSelection()
{
}

void DataHandlerImpl::printSelection()	
{
}

void DataHandlerImpl::paste()
{
	TemplateView *t=dynamic_cast<TemplateView *>(this);
	
	if(t && canPaste() && QUriDrag::canDecode(ClipboardWrapper::thisInstance()->data()))
	{
		QUriDrag *uriList=(QUriDrag *)ClipboardWrapper::thisInstance()->pasteData();
		QStrList pathList;
		QUriDrag::decode(uriList, pathList);
		bool shouldMove=ClipboardWrapper::thisInstance()->shouldCutSource();
		
		for(QStrListIterator it(pathList); it.current(); ++it)
		{
			QString sourcePath=(const char *)(*it);
			
			if(shouldMove)
				// move source here
				BrokerInterface::thisInstance()->move(sourcePath, t->path());
			else
        // copy source here
        BrokerInterface::thisInstance()->copy(sourcePath, t->path());
		}
	}
}

void DataHandlerImpl::copySelectionTo()
{
	if(!isSelectionEmpty())
	{
		TemplateView *t=dynamic_cast<TemplateView *>(childViews.at(0));
		if(t && dynamic_cast<VObject *>(t->getVItem()))
		{
			QString objectType=((VObject *)t->getVItem())->parentFolder()->mimeType();
			//VFolder *folder=ClientVFS::thisInstance()->folderRef(ContentsWidget::ref()->getCurrentFolder());
			DestinationDialog *d=new DestinationDialog("Copy", objectType, 0);
			int res=d->exec();

			if(res==QDialog::Accepted)
			{
				FolderTreeItem *selectedItem=d->selectedItem();
				QString filePath=selectedItem->getFilePath();

				if(filePath)
				{
					// export current selection
				}
				else
				{
					// move current selection	
					QList<DataWidget> selectedViews=getSelection();
					QString destFolder=selectedItem->path();

	        for(QListIterator<DataWidget> it(selectedViews); it.current(); ++it)
	        {
        		t=dynamic_cast<TemplateView *>((*it));
        		if( t )
							BrokerInterface::thisInstance()->copy(t->path(), destFolder);
	        }
				}
			}					
			delete d;
		}
		else
		{
			printf("Warning: could not determine object mime type, bailing out\n");
		}
	}
	else
	{
		printf("Warning: there is nothing to copy, bailing out\n");
	}
}

void DataHandlerImpl::moveSelectionTo()
{
	if(!isSelectionEmpty())
	{
		TemplateView *t=dynamic_cast<TemplateView *>(childViews.at(0));
		if(t && dynamic_cast<VObject *>(t->getVItem()))
		{
			QString objectType=((VObject *)t->getVItem())->parentFolder()->mimeType();
			//VFolder *folder=ClientVFS::thisInstance()->folderRef(ContentsWidget::ref()->getCurrentFolder());
			DestinationDialog *d=new DestinationDialog("Move", objectType, 0);
			int res=d->exec();

			if(res==QDialog::Accepted)
			{
				FolderTreeItem *selectedItem=d->selectedItem();
				QString filePath=selectedItem->getFilePath();

				if(filePath)
				{
					// export current selection
				}
				else
				{	
					// move current selection	
					QList<DataWidget> selectedViews=getSelection();
					QString destFolder=selectedItem->path();
					TemplateView *t;

					bool setExpungeMode=false;

					if (dynamic_cast<MailListView *>(this)) {
						setExpungeMode=true;
						ClientRMI::ref()->setAutoExpunge(true);
					}

	        for(QListIterator<DataWidget> it(selectedViews); it.current(); ++it)
	        {
        		t=dynamic_cast<TemplateView *>((*it));
        		if( t )
        		{
		          if( it.atLast() && setExpungeMode )
						    ClientRMI::ref()->setAutoExpunge(false);
							BrokerInterface::thisInstance()->copy(t->path(), destFolder);
        		}
	        }
				}
			}

			delete d;
		}
		else
		{
			printf("Warning: could not determine object mime type, bailing out\n");
		}
	}
	else
	{
		printf("Warning: there is nothing to move, bailing out\n");
	}
}

void DataHandlerImpl::saveSelection()
{
}

void DataHandlerImpl::editProperties()
{
}

void DataHandlerImpl::dragStart(QWidget *dragSource)
{
  QList<DataWidget> selectedViews = getSelection();
  QStrList uriList;
  TemplateView *tw;

  for(QListIterator<DataWidget> it(selectedViews); it.current(); ++it)
  {
    tw=dynamic_cast<TemplateView *>((*it));
    if(tw)
      uriList.append((const char *)tw->path());
  }

  if(uriList.count())
  {
		printf("\nStarting drag for %d items\n", uriList.count());
    DataHandler::grayOutSelection();
		QUriDrag *d = new QUriDrag(uriList, dragSource);
		d->drag();
  }
}

void DataHandlerImpl::dragEnter(QDragEnterEvent* event)
{
	event->accept(QUriDrag::canDecode(event));
}

void DataHandlerImpl::dragDrop(QDropEvent* event)
{
	TemplateView *t=dynamic_cast<TemplateView *>(this);
	QStrList pathList;

	if(t && QUriDrag::decode(event, pathList))
	{
		for(QStrListIterator it(pathList); it.current(); ++it)
		{
			QString sourcePath=(const char *)(*it);

			BrokerInterface::thisInstance()->move(sourcePath, t->path());
		}
	}
}

