
/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <warray.h>
#include <qcolor.h>
#include <stdio.h>

#define DEBUG_WARRAY

#define CELL_X_SPACING 5
#define CELL_Y_SPACING 1

WArray::WArray(QWidget *parent, const char *name):QTableView(parent, name)
{
  widgetList.setAutoDelete(true);
  aRows=0;
  setBackgroundColor(QColor("white"));
  setAutoUpdate(true);
  setTableFlags(Tbl_autoVScrollBar | Tbl_snapToGrid);
}

WArray::~WArray()
{
}

void WArray::insertWidget(int row, int col, QWidget *w, bool centerX, bool centerY)
{
  widgetList.append(w);
  posList.append(QPoint(row, col));
  
  // move the widget to the appropriate position
  int x=0, y;
  for(int i=0;i<col;i++) x+=cellWidth(i);
  if(centerY)
    y=row*cellHeight()+(cellHeight()-w->height())/2;
  else
    y=row*cellHeight()+CELL_Y_SPACING;
  if(centerX)
    x+=(cellWidth(col)-w->width())/2;
  else
    x+=CELL_X_SPACING;
  w->move(x, y);
  w->show();
}

void WArray::removeWidget(int row, int col)
{
	int pos=-1;
	for(unsigned int i = 0; i < posList.count(); i++) {
		if ( (posList[i].x()==row) && (posList[i].y()==col) )
			pos=i;
		if (pos != -1)
		{
			posList.remove(posList.at(pos));
			widgetList.remove(pos);
		}
	}
}

void WArray::removeLine(int row)
{
  for (unsigned int c=0; c < posList.count(); c++)
  {
    while (posList[c].x() == row) {
      removeWidget(c, posList[c].y());
    }
  }
}

void WArray::setColumnWidth(unsigned int col, unsigned int w)
{
	if (sizeList.size() <= col) {
		sizeList.resize(col+1);
	}
	sizeList[col]=w;
}

void WArray::setRowHeight(int h)
{
  setCellHeight(h);
}

void WArray::setNumCols(int cols)
{
  QTableView::setNumCols(cols);
}

void WArray::setNumActiveRows(int rows)
{
  aRows=rows;
}

int WArray::numCols() const
{
  return QTableView::numCols();
}

int WArray::numActiveRows() const
{
  return aRows;
}

int WArray::cellWidth(int col)
{
  return sizeList[col];
}

void WArray::resizeEvent(QResizeEvent *e)
{
#ifdef DEBUG_WARRAY
  printf("Warray, resizeEvent: height set to %d\n", e->size().height());
  printf("Warray, resizeEvent: cellHeight set to %d\n", cellHeight());
#endif
  if(cellHeight()!=0)
  {
    int n=e->size().height()/cellHeight();
    if(n>aRows)
      setNumRows(n);
    else
      setNumRows(aRows);
  }
  else
    setNumRows(aRows);
#ifdef DEBUG_WARRAY
  printf("Warray: numRows set to %d\n", numRows());
#endif
  QTableView::resizeEvent(e);
  repaint();
}

void WArray::paintEvent(QPaintEvent *e)
{
  QPainter p(this);
  p.setPen(DotLine);
  int h=height(), w=width(), ch=cellHeight(), x=0;
  for(int i=0;i<numCols()-1;i++)
  {
    x+=cellWidth(i);
    p.moveTo(x, 0);
    p.lineTo(x, h);
  }
  for(int i=1;i<numRows()+1;i++)
  {
    p.moveTo(0, i*ch);
    p.lineTo(w, i*ch);
  }
}

void WArray::paintCell(QPainter *p, int row, int col)
{
}




