/*
 * misc.cc
 * Copyright (C) 2000 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 15 Jan 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 
#include "aewm.hh"

using namespace std;

void forkExec(char *cmd)
{
    if(! (strlen(cmd)>0)) return;
    
    pid_t pid = fork();

    switch (pid) {
        case 0:
            execlp("/bin/sh", "sh", "-c", cmd, NULL);
	    cerr << "exec failed, cleaning up child" << endl;
            exit(1);
        case -1:
	    cerr << "can't fork" << endl;
    }
}

void sigHandler(int signal)
{
    switch (signal) {
    	case SIGKILL:
        case SIGINT:
        case SIGTERM:
        case SIGHUP:
	    wm->quitNicely(); break;
        case SIGCHLD:
            wait(NULL); break;
    }
}

int handleXError(Display *dpy, XErrorEvent *e)
{
    if (e->error_code == BadAccess && e->resourceid == wm->getRootWindow()) {
	cerr << "root window unavailable (maybe another wm is running?)" << endl;
        exit(1);
    }
   
    return 0;
}

// Yeah, yeah I know this function is C code, but who cares!
//
// Some systems do not have setenv(). This one is modeled after 4.4 BSD, but
// is implemented in terms of portable primitives only: getenv(), putenv()
// and malloc(). It should therefore be safe to use on every UNIX system.
//  
// If clobber == 0, do not overwrite an existing variable.
// 
// Returns nonzero if memory allocation fails.
//
// Author: Wietse Venema, Eindhoven University of Technology, The Netherlands.
//
// setenv - update or insert environment (name,value) pair
#ifdef NEED_SETENV
int setenv(char *name, char *value, int clobber)
{
    char   *cp;

    if (clobber == 0 && getenv(name) != 0)
	return (0);
    if ((cp = (char *)malloc(strlen(name) + strlen(value) + 2)) == 0)
	return (1);
    sprintf(cp, "%s=%s", name, value);
    return (putenv(cp));
}
#endif
