// ---------------------------------------------------------------------------
// - t_sha512.cpp                                                            -
// - afnix cryptography - SHA-512 class tester module                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Sha512.hpp"

int main (int, char**) {
  using namespace afnix;

  // create a SHA-512 message digest
  Sha512 md;
  if (md.getname () != "SHA-512") return 1;

  // check digest as specified in FIPS PUB 180-2
  String digest = md.compute ("abc");
  if (digest != "DDAF35A193617ABA" "CC417349AE204131"
                "12E6FA4E89A97EA2" "0A9EEEE64B55D39A"
                "2192992A274FC1A8" "36BA3C23A3FEEBBD"
                "454D4423643CE80E" "2A9AC94FA54CA49F") return 1;

  // the afnix test as usual
  digest = md.compute ("afnix");
  if (digest != "40B11B89056BBB0B" "D2266AD30E1ADE9D"
                "EE2CECFFB8950A23" "AE4FE666EC80E054"
                "10727E900029313F" "1D10269F1609638F"
                "B0CB82D419D82743" "A96167AA1E80E21E") return 1;

  digest = md.compute ("afnix programming language");
  if (digest != "FE4C9F7E031C5988" "141BE55E019C17CF"
                "4C0E789B595F1BE9" "B233259BD3ACB635"
                "D60C8DBFF8543672" "F052B29F62F82B0F"
                "A9DA01962DB016EB" "30AA657A50EBB2AB") return 1;

  // success
  return 0;
}
