// ---------------------------------------------------------------------------
// - t_cnfd.cpp                                                              -
// - unicode database (ucd) library - normal form decomposition (nfd) tester -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "t_cnft.hxx"

namespace afnix {
  // this procedure returns true if a field is a single code point
  static bool nfd_is_single (const t_quad fld[NFT_ELM_MAX]) {
    if (fld[0] == nilq) return false;
    for (long i = 1; i < NFT_ELM_MAX; i++) {
      if (fld[i] != nilq) return false;
    }
    return true;
  }

  // this procedure compare 2 fields
  static bool nfd_cmp_fld (const t_quad dst[UCD_CDV_MAX], 
			   const t_quad fld[UCD_CDV_MAX]) {
    for (long i = 0; i < UCD_CDV_MAX; i++) {
      if (dst[i] != fld[i]) return false;
    }
    return true;
  }

  // this procedure test a nfd transformationd at index 0
  static bool nfd_test_0 (void) {
    // loop in the test data
    for (long i = 0; i < NFT_TEST_SIZE; i++) {
      // get the data sample
      const nft_t* data = &NFT_TEST_DATA[i];
      // check for single code point
      t_quad dst[UCD_CDV_MAX];
      if (nfd_is_single ((*data)[0]) == true) { 
	// get the code point and transform it
	t_quad code = (*data)[0][0];
	c_ucdnfd (dst, code);
	// compare two fields
	if (nfd_cmp_fld (dst, (*data)[2]) == false) {
	  return false;
	}
      }
      // check for a full array
      c_ucdnfd (dst, (*data)[0]);
      // compare two fields
      if (nfd_cmp_fld (dst, (*data)[2]) == false) {
	return false;
      }
    }
    return true;
  }
}

int main (int, char**) {
  using namespace afnix;

  // check first the version consistency
  if (NFT_MAJOR != UCD_MAJOR) return 1;
  if (NFT_MINOR != UCD_MINOR) return 1;
  if (NFT_PATCH != UCD_PATCH) return 1;
  
  // check consistent UCD_CDV_MAX SIZE/NFT_ELM_MAX
  // this ensure that the array have the same size
  if (UCD_CDV_MAX != NFT_ELM_MAX) return 1;

  // test the single code point first
  if (nfd_test_0 () == false) return 1;

  // done
  return 0;
}
