// ---------------------------------------------------------------------------
// - Ico.hpp                                                                 -
// - afnix:csm service - intercom cloud object class definition              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2016 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_ICO_HPP
#define  AFNIX_ICO_HPP

#ifndef  AFNIX_RCO_HPP
#include "Rco.hpp"
#endif

namespace afnix {

  /// The Ico class is an intercom cloud object. The object is derived from
  /// the registered cloud object and is augmented with a intercom command.
  /// Typically an intercom object is sent by over a channel as a registered
  /// cloud object. The command associated helps the receiver to decide what
  /// to do with the rco. The registration id can be used to validate the
  /// requested and eventually store the rco in the cloud object set.
  /// @author amaury darsch

  class Ico : public Rco {
  protected:
    /// the intercom command
    String  d_ixo;

  public:
    /// create nil object
    Ico (void);
    
    /// create an intercom object by command and rco
    /// @param ixo the intercom command
    Ico (const String& ixo, const Rco& rco);
    
    /// copy construct this registered object
    /// @param that the object to copy
    Ico (const Ico& that);

    /// @return the class name
    String repr (void) const;

    /// @return a clone of this object
    Object* clone (void) const;

    /// @return the ico serial id
    t_byte serialid (void) const;

    /// serialize this object
    /// @param os the output stream
    void wrstream (OutputStream& os) const;

    /// deserialize this object
    /// @param is the input stream
    void rdstream (InputStream& os);

    /// assign an ico to this one
    /// @param that the object to assign
    Ico& operator = (const Ico& that);

    /// set the intercom command
    /// @param ixo the command name
    virtual void setixo (const String& ixo);

    /// @return the intercom command name
    virtual String getixo (void) const;

  public:
    /// create a object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
