/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#include <cstring>  // for strlen()

#include <config.h>
#ifdef HAVE_GNOME
#include <libgnome/gnome-url.h>
#endif // HAVE_GNOME

#include <gtkmm/icontheme.h>

#include "gcs-about-window.h"
#include "gcs-i18n.h"

namespace gcs
{
    namespace Dialogs
    {
        const int AboutWindow::m_logoSize = 150;

        AboutWindow::AboutWindow(void)
        {
            set_name(PACKAGE_NAME);

#ifdef HAVE_GNOME
            set_url_hook(sigc::mem_fun(*this, &AboutWindow::on_link_clicked));
            set_website(PACKAGE_WEBSITE);
            set_website_label(_("Project Website"));
#endif // HAVE_GNOME

            Glib::ustring version(PACKAGE_VERSION);
            set_version(version);

            set_copyright("\xC2\xA9 2005-2006 Jonathon Jongsma");

            Glib::ustring comments(
                    _("A colorscheme designer for the GNOME desktop"));
            if (strlen(GIT_REVISION))
            {
                comments.append("\n\n[ " GIT_REVISION " ]");
            }
            set_comments(comments);

            Glib::ustring license = "This program is free software; you can redistribute it and/or modify\n"
                "it under the terms of the GNU General Public License as published by\n"
                "the Free Software Foundation; either version 2 of the License, or\n"
                "(at your option) any later version.\n\n"

                "This program is distributed in the hope that it will be useful,\n"
                "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
                "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
                "GNU General Public License for more details.\n\n"

                "You should have received a copy of the GNU General Public License\n"
                "along with this program; if not, write to the \n"
                "Free Software Foundation, Inc., 59 Temple Place, Suite 330, \n"
                "Boston, MA  02111-1307  USA\n";
            set_license(license);

            m_authors.push_back("Jonathon Jongsma <jonathon.jongsma@gmail.com>");
            set_authors(m_authors);

            // Translators: change this to your name, separate multiple names with \n
            Glib::ustring translation_credits = _("translator-credits");
            set_translator_credits(translation_credits);

            Glib::RefPtr<Gtk::IconTheme> theme = Gtk::IconTheme::get_default();
            const Glib::ustring icon_name = "agave-icon";
            // FIXME: Unix path separators
            if (theme->has_icon(icon_name))
            {
                m_logo = theme->load_icon(icon_name, m_logoSize,
                        Gtk::ICON_LOOKUP_USE_BUILTIN);
                set_logo(m_logo);
            }
        }


        void AboutWindow::on_link_clicked(Gtk::AboutDialog& dialog,
                const Glib::ustring& link)
        {
#ifdef HAVE_GNOME
            gnome_url_show(link.c_str(), 0);
#endif // HAVE_GNOME
        }

    } // namespace Dialogs
} // namespace gcs
