/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_SCHEMEBOX_WIDGET_H
#define __GCS_SCHEMEBOX_WIDGET_H

#include <gtkmm/box.h>
#include <gtkmm/menu.h>

#include "gcs-textswatch.h"
#include "core/gcs-scheme.h"

namespace gcs
{
    namespace Widgets
    {

        class SchemeBox : public Gtk::HBox
        {
            public:
                SchemeBox(void);
                SchemeBox(const SchemeBox& other);
                SchemeBox(Scheme schm);
                SchemeBox(Color c, tSchemeType t);
                virtual ~SchemeBox(void);

                void set_scheme(Scheme schm);
                inline ref_scheme_type get_scheme(void) { return m_pScheme; }

                void set_color(ColorPtr clr);
                inline ColorPtr get_color(void) { return m_pScheme->get_color(); }

                void set_scheme_type(tSchemeType t);
                inline tSchemeType get_scheme_type(void) { return m_pScheme->get_scheme_type(); }

                //void setSwatchPopup(Gtk::Menu *mnu);

                sigc::signal<void, ColorPtr>& signal_color_selected() {
                    return m_signal_color_selected; }

            protected:
                void init(void);
                void redraw(void);
                bool on_color_selected(gint swatch_id);

            private:
                static const gint NUM_SWATCHES = 4;

                sigc::signal<void, ColorPtr> m_signal_color_selected;

                ref_scheme_type m_pScheme;
                TextSwatch* m_pSwatches[NUM_SWATCHES];
        };

    } // namespace Widgets
} // namespace gcs

#endif // __GCS_SCHEMEBOX_WIDGET_H
