#ifndef _DOOR_H
#define _DOOR_H

#include "strings.h"
#include "item.h"
#include "builder.h"

#define DOOR_OPEN     0
#define DOOR_CLOSED   1
#define DOOR_LOCKED   2
#define DOOR_MLOCKED  3
#define DOOR_MAXSTATE DOOR_MLOCKED

#ifdef DOOR_C
char *statenames[] = {"Open", "Closed", "Locked", "Magically Locked"};
char *ropestatenames[] = {"Tied", "Untied", "Short", "Error"};

#else
extern char *statenames[];
#endif

class Door : public Item
{
public:

   Door(char *the_name, char *the_area);
   virtual ~Door();

   void    write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   char    *get_outside_loc(void);
   int     set_outside_loc(char *thelocation);
   int     set_outside_desc(char *thedesc);
   char    *get_outside_desc(void);
   char    *get_inside_desc(void);
   char    *get_door_desc(Location *the_loc);
   int     set_door_state(int newstate);
   int     get_door_state(void);
   int     set_distance(int newval);
   int     get_distance(void);
   int     set_rope_name(char *the_name);
   char    *get_rope_name(void);
   int     set_inside_brief(int descnr, char *thebriefdesc);
   char    *get_inside_brief(int descnr);
   int     set_outside_brief(int descnr, char *thebriefdesc);
   char    *get_outside_brief(int descnr);
   char    *get_brief(Location *the_loc);
   char    *get_link(Location *the_location, int *return_val);   
   int     find_key(char *keyname);
   int     set_key_names(char *thenames);
   char    *get_key_names(void);
   int     toggle_lock(char *keyname);
   Door    *operator = (Door *copy_from); 
   int     read_door_attrib(FILE *read_file, ErrLog *error_log);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

private:

   Door();

   Strings outside_loc;

   Strings outside_desc;  /* for inside examines */
   short   doorstate;

   Strings inside_brief[DOOR_MAXSTATE+1];
   Strings outside_brief[DOOR_MAXSTATE+1];

   Strings key_names;

   Strings rope_name;
   int     distance;
};

#endif







































