#ifndef _ITEMFLAGS_H_
#define _ITEMFLAGS_H_

#define ITEMFLAG_CONTAINER     0  // is a container object
#define ITEMFLAG_LIGHTABLE     1  // you can light and extinquish it
#define ITEMFLAG_LIT           2  // it is lit to start with
#define ITEMFLAG_GLOWING       3  // it is magically giving off light
#define ITEMFLAG_BOOZE         4  // Will eating this make them drunk
#define ITEMFLAG_ROPETIE       5  // Is a door for ropes
#define ITEMFLAG_ISTIED        6  // The rope is currently tied
#define ITEMFLAG_TIEINSIDE     7  // The rope can be tied to the door inside
#define ITEMFLAG_TIEOUTSIDE    8  // The rope can be tied to the door outside
#define ITEMFLAG_UNTIEINSIDE   9  // Rope can be untied from the door inside
#define ITEMFLAG_UNTIEOUTSIDE 10  // Rope can be untied from the door outside
#define ITEMFLAG_SPECIALDOOR  11  // Door that can't be opened by normal 
                                  // means, only via a special
#define ITEMFLAG_HIDDENDOOR   12  // Door does not show up on exits or
                                  // look when closed 
#define ITEMFLAG_LOCKABLE     13  // Lockable container
#define ITEMFLAG_CLOSEABLE    14  // closeable container
#define ITEMFLAG_LOCKED       15  // container is locked
#define ITEMFLAG_CLOSED       16  // container is closed, not locked
#define ITEMFLAG_MAILBOX      17  // obj is a mailbox or mailman.  Mail can
                                  // be read if this object is in the room
#define ITEMFLAG_WORN         18  // is the object worn

#ifdef ITEM_C

char *itemflagnames[] = {"Container", "Lightable", "Lit", "Glowing",
       "Booze", "RopeTie", "IsTied",  "TieInside", "TieOutside", 
       "UntieInside", "UntieOutside", "SpecialDoor", "HiddenDoor", 
       "Lockable", "Closeable", "Locked", "Closed", "Mailbox", NULL};

int itemflagfrozen[] = {ITEMFLAG_ISTIED, ITEMFLAG_WORN, -1};

#else

extern char *itemflagnames[];
extern int itemflagfrozen[];


#endif
#endif




