#ifndef _LOCATION_DBASE
#define _LOCATION_DBASE

#include "entity.h"

struct b_node_l
{   char   *key;
    Entity *data;
    b_node_l *left;
    b_node_l *right;

    b_node_l *next;
};

class btree_l
{
public:
   btree_l();
   ~btree_l();

   int    add(char *key,Entity *data);
   int    del(char *key);
   int    rem(char *key);
   Entity *find(char *key);
   bool   can_find(char *key);
   int    reset_next_in_list();
   Entity *get_next_in_list();

   int    clr_list();

   void show();
   void save_state();
   void restore_state();

private:
   int    add_node(b_node_l **baseptr,b_node_l *newnode);
   int    del_node(b_node_l **baseptr,char *key, int del_data);
   Entity *find_node(b_node_l *baseptr, char *key);
   void show(b_node_l *baseptr,int level); 
   int free_node(b_node_l *the_node);

   // The start of all the mess, the root of the tree.
   b_node_l *root;
   b_node_l *root_list;		
   b_node_l *last_added;
   b_node_l *next_in_list;

   b_node_l *next_in_list_saved;
};

#endif

