#ifndef _BTREE_H
#define _BTREE_H

#include "linkedlist.h"

template<class TYPE>
class b_node
{
  public:
    char   *key;
    TYPE   *data;
    b_node<TYPE> *left;
    b_node<TYPE> *right;
};

template<class TYPE>
class btree
{
public:
   btree();
   ~btree();

   int    add(char *key,TYPE *data);
   int    del(char *key);
   int    rem(char *key);
   TYPE   *find(char *key);
   bool   can_find(char *key);
   void   reset_current();
   TYPE   *get_next();

   int    clr_tree();
   void   set_del_data();

   void show();
   void push_current();
   void pop_current();

private:
   int    add_node(b_node<TYPE> **baseptr,b_node<TYPE> *newnode);
   int    del_node(b_node<TYPE> **baseptr,char *key, int del_data);
   TYPE   *find_node(b_node<TYPE> *baseptr, char *key);

   void show(b_node<TYPE> *baseptr,int level); 

   // The start of all the mess, the root of the tree.
   b_node<TYPE> *root;
   LinkedList< b_node<TYPE> > the_list;
   int del_data;
};

#endif

