#ifndef __AIME_SYSDEP_H_
#define __AIME_SYSDEP_H_


#define __USE_XOPEN
#define AIME_DAEMONIZABLE
#define AIME_SIGNALS

#define STRNCASECMP( a, b, n )   strncasecmp( (a), (b), (n) )
#define STRCASECMP( a, b )   strcasecmp( (a), (b) )
#define BZERO( a, n )   bzero( (a), (n) )
#define RAISE( n )   raise( n )
#define STRSEP( a, b )   strsep( (a), (b) )
#define VSNPRINTF( b, s, f, a )   vsnprintf( (b), (s), (f), (a) )
#define SNPRINTF   snprintf


#if defined( __CYGWIN__ )
// ifdef CYGWIN must come before ifdef WIN32

#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <rpc.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <time.h>
#include <unistd.h>

#include <arpa/inet.h>
#include <arpa/telnet.h>

#include <netinet/in.h>

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>



#elif defined( linux )

#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <time.h>
#include <unistd.h>

#include <arpa/inet.h>
#include <arpa/telnet.h>

#include <netinet/in.h>

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>

#include <asm/param.h>

#include <rpc/types.h>



#elif defined( WIN32 )

#undef AIME_DAEMONIZABLE
#undef AIME_SIGNALS

#define AIME_WIN32

#define MAXHOSTNAMELEN  64
#define IAC             255     /* interpret as command: */
#define WONT            252     /* I won't use option */
#define WILL            251     /* I will use option */
#define TELOPT_ECHO     1       /* echo */
#define TELOPT_NAOFFD   13      /* negotiate about formfeed disposition */
#define TELOPT_NAOCRD   10      /* negotiate about CR disposition */

#undef STRNCASECMP
#define STRNCASECMP( a, b, n )   strnicmp( (a), (b), (n) )

#undef STRCASECMP
#define STRCASECMP( a, b )   stricmp( (a), (b) )

#undef BZERO
#define BZERO( a, n )   memset( (a), 0, (n) )

#undef RAISE
#define RAISE( a )   exit( a )

#undef STRSEP
#define STRSEP( a, b )   str_sep( (a), (b) )

#undef VSNPRINTF
#define VSNPRINTF( b, s, f, a )   _vsnprintf( (b), (s), (f), (a) )

#undef SNPRINTF
#define SNPRINTF   _snprintf

#include <afxwin.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


#else
#error "Unknown platform!"
#endif


#endif // __AIME_SYSDEP_H_
