/**********************************************************************
 ** Shared - functions to convert any area format to the AIME format
 **  
 **
 **    
 **
 **********************************************************************/

#ifndef SHARED_C
#define SHARED_C

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "shared.h"
#include "../../include/strings.h"
#include "../../include/lexer.h"
#include "../../include/config.h"
#include "../../include/sysdep.h"




/***********************************************************************
 ** read_mod_desc_type - reads in a description type from a file, modified
 **                      version to accept more than just ^
 **
 ** Parameters: read_file - the file to read in from
 **             bracket_char - ??????
 **             the_char - the char surrounding the text
 **
 ** Returns: a pointer to the created string
 **
 ***********************************************************************/

char *read_mod_desc_type(FILE *read_file, int bracket_char, char the_char)
{
   token_record *the_token;
   token_record *temp_tok;
   int size = 0;
   char *temp_desc;
   Strings holder;
   int first = 1;
  
   /* get the location description and get its size, how many characters */
   the_token = get_token(read_file, the_char);
   temp_tok = the_token;
   while (temp_tok != NULL)
   {
      size = size + strlen(temp_tok->the_string) + 1;
      temp_tok = temp_tok->more;  
   }


   /* create the description array given the size we need to store, efficient
      use of memory by dynamically allocating it based on size. We use this
      instead of the method provided by strings since this is more efficient
      to do one malloc instead of a malloc and destroy for each additional
      line in the desc. */
   temp_desc = (char *) malloc(size + 2);
   BZERO(temp_desc, size + 2);

   /* load the desc strings into the array */
   temp_tok = the_token;
   while (temp_tok != NULL)
   {
      /* remove the preceeding newline */
      if (!first)
      {
         strcat(temp_desc, temp_tok->the_string);
         strcat(temp_desc, "\n");
      }
      else
      {
         char *tmp_str;

         tmp_str = temp_tok->the_string;
         while ((*tmp_str) && (*tmp_str == ' '))
	    tmp_str++;

         if ((*tmp_str) && (*tmp_str != '\n') && 
             (*tmp_str != '\r') && (*tmp_str != '\0'))
	 {
            strcat(temp_desc, temp_tok->the_string);
            strcat(temp_desc, "\n");
         }
         first = 0;
      }
      temp_tok = temp_tok->more;
   }

   bracket_char = 0;
 
   return temp_desc;
}




#endif





