/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#ifndef __BSSID_LIST_H
#define __BSSID_LIST_H

#include <gtk/gtk.h>
#include <glib.h>
#include <semaphore.h>
#include <pthread.h>
#include "RC4.h"
#include "Packet.h"
#include "crack.h"
#include "capture.h"

typedef struct BssidList_t {
   int numPackets;
   int interesting;
   int channel;
   int rownum;
   int queueLen;
   unsigned char lastiv[3];
   unsigned char bssid[6];
   char *name;
   struct BssidList_t *next;

   pthread_t crackerThread;
   CrackNode *ap;

   sem_t crackSem;
} BssidList;

extern BssidList *head, *tail;

void queueIt(unsigned char *bssid, Packet *p);
BssidList *ssidFind(const unsigned char *bssid);
BssidList *rowFind(int row);
int isResolved(unsigned char *p);
char *ivtostr(unsigned char *iv);
char *bssidtostr(unsigned char *bssid);
BssidList *newBssidNode(unsigned char *bssid, int chan);
int bssidMatch(const unsigned char *bssid1, const unsigned char *bssid2);
void addBssid(CaptureRec *cap);
void addBssidFromBeacon(CaptureRec *cap);
void clearList();


#endif
