#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <pthread.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "display.h"
#include "PacketSource.h"
#include "capture.h"
#include "crack.h"
#include "bssidlist.h"

int scan = 1;
int chan = 6;
int spinchan = 6;
int funcId = 0;
int doCapture = 0;
pthread_t capThread;
int breadth40 = 3;
int breadth128 = 2;
int quitting = 0;

GtkCList *theList;
GdkEventButton *popupEvent;

/* Function to open a dialog box displaying the message provided. */

void quick_message(char *title, char *message) {

   GtkWidget *dialog, *label, *okay_button;

   /* Create the widgets */
   
   dialog = gtk_dialog_new();
   gtk_window_set_title(GTK_WINDOW(dialog), title);
   gtk_window_set_modal(GTK_WINDOW(dialog), 1);
   gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
   gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area), 10);
   gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), 10);

   label = gtk_label_new (message);
   okay_button = gtk_button_new_with_label("Okay");
   
   /* Ensure that the dialog box is destroyed when the user clicks ok. */
   
   gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",
                              GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(dialog));
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->action_area), okay_button, TRUE, FALSE, 0);

   /* Add the label, and show everything we've added to the dialog. */

   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
                      label);
   gtk_widget_show_all (dialog);
}

void
on_AirSnortWindow_realize              (GtkWidget       *widget,
                                        gpointer         user_data)
{
   theList = (GtkCList*) user_data;
   if (!funcId) {
      funcId = gtk_timeout_add( 500, (GtkFunction) update, user_data); 
   }
}


gboolean
on_AirSnortWindow_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   if (!head) {
      doCapture = 0;
      gtk_main_quit();
   }
   else {
      gtk_widget_show_all (create_CloseDlg());
   }

  return TRUE;
}


void
on_load_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   if (doCapture) {
      quick_message("Error", "Can't load while capture in progress");
      return;
   }
   gtk_widget_show_all (create_FileLoad());
}


void
on_save_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gtk_widget_show_all (create_SaveFile());
}


void
on_exit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   if (!head) {
      doCapture = 0;
      gtk_main_quit();
   }
   else {
      gtk_widget_show_all (create_CloseDlg());
   }
}


void
on_clear_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   on_Clear_clicked(NULL, (gpointer)theList);
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gtk_widget_show_all (create_PrefsDlg());
}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gtk_widget_show_all (create_AboutDlg());
}


void
on_Start_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
   char cmd[80];
   if (doCapture) return;

   if (!scan) {
      chan = spinchan;
   }
   if (!useOrinoco && use_PF_PACKET) {
      sprintf(cmd, "wlanctl-ng %s lnxreq_ifstate ifstate=enable > /dev/null", dev);
      system(cmd);
   }
   if (setChannel(chan)) {
      quick_message("Error", "Could not set promiscuous mode");
      return;
   }  
   doCapture = 1;
   pthread_create(&capThread, NULL, capture, NULL);
}


void
on_Stop_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
   doCapture = 0;
}


void
on_freq_changed                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
   spinchan = gtk_spin_button_get_value_as_int((GtkSpinButton*) editable);
   if (!scan) {
      chan = spinchan; 
      if (doCapture) {
         setChannel(chan);
      }
   }
}


void
on_scan_toggled                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   scan = gtk_toggle_button_get_active(togglebutton); 
   if (!scan) {
      chan = spinchan; 
      if (doCapture) {
         setChannel(chan);
      }
   }
}


void
on_Clear_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_clist_clear((GtkCList*) user_data);
   clearList();
}


void
on_DataList_select_row                 (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

}

void myPositionFunc(GtkMenu *menu, int *x, int *y, gpointer data) {
   popupEvent = (GdkEventButton*) data;
   *x = popupEvent->x_root;
   *y = popupEvent->y_root;
}

gboolean
on_DataList_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
   if (event->button == 3) {
      gtk_menu_popup (GTK_MENU(create_ListPopup()), NULL, NULL, 
                      myPositionFunc, event, event->button, 0);
   }
   return FALSE;
}


void
on_breadth40_show                      (GtkWidget       *widget,
                                        gpointer         user_data)
{
   gtk_spin_button_set_value((GtkSpinButton*) widget, breadth40);
}


void
on_breadth128_show                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
   gtk_spin_button_set_value((GtkSpinButton*) widget, breadth128);
}


void
on_PrefsOkGet40_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
   breadth40 = gtk_spin_button_get_value_as_int((GtkSpinButton*) user_data);
}


void
on_PrefsOkGet128_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   breadth128 = gtk_spin_button_get_value_as_int((GtkSpinButton*) user_data);
}


void
on_CloseYes_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
   quitting = 1;
   gtk_widget_show_all (create_SaveFile());
}


void
on_CloseNo_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
   doCapture = 0;
   gtk_main_quit();
}

void
loadPacketFile                         (GtkButton       *button,
                                        gpointer         user_data)
{
   PacketInfo pi;
   CaptureRec cap;
   unsigned char bssid[6], sta[] = {0,0,0,0,0,0};
   int len;
   unsigned char slen, chan;
   char *fname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data));
   int fd = open(fname, O_RDONLY);
   cap.pInfo = &pi;
   cap.bssid = bssid;
   cap.sta = sta;
   if (fd != -1) {
      while (read(fd, &len, sizeof(int)) == sizeof(int)) {
         if (read(fd, bssid, 6) != 6) {
         }
         if (len == 0) {   //this is name info
            if (read(fd, &chan, 1) != 1) {
            }
            pi.channel = chan;
            if (read(fd, &slen, 1) != 1) {
            }
            pi.name = (char*) malloc(slen + 1);
            if (read(fd, pi.name, slen) != slen) {
            }  
            pi.name[slen] = 0;
            addBssidFromBeacon(&cap);
         }
         else {
            pi.channel = 0;
            pi.pack = (Packet *) malloc(sizeof(Packet));
            cap.iv = pi.pack->buf = (unsigned char *) malloc(len - 6);
            pi.pack->len = len - 6;
            pi.pack->next = NULL;
            if (read(fd, pi.pack->buf, len - 6) != (len - 6)) {
            }
            addBssid(&cap);
         }
      }
      close(fd);
   }
}

/***********************************************************

  format of saved data:

  For ksample packets:

  4 byte integer length of 802.11b data = n+6 (includes bssid)
  6 byte bssid
  n bytes of packet data
     3 byte IV
     n-3 bytes of data w/ 802.11b checksum at the end

  For sample packets

  4 byte integer length = 11
  6 byte bssid
  5 bytes of packet data
     3 byte IV
     1 dummy byte = 0
     1 byte = first byte of 802.11b data (the 0xAA byte)

  For AP name information

  4 byte integer length = 0
  6 byte bssid
  1 byte channel number
  1 byte length of name = n
  n byte AP name

************************************************************/

void
savePacketData                         (GtkButton       *button,
                                        gpointer         user_data)
{
   unsigned char first, dummy = 0;
   Packet *pkt;
   Sample *samp;
   BssidList *temp = head;
   int len, i;
   unsigned char uchar;
   char *fname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data));
   int fd = open(fname, O_WRONLY | O_CREAT, 0644);
   if (fd != -1) {
      for (; temp; temp = temp->next) {
         if (temp->name) {
            len = 0;
            write(fd, &len, sizeof(int));
            write(fd, temp->bssid, 6);
            uchar = temp->channel;
            write(fd, &uchar, 1);
            uchar = strlen(temp->name);
            write(fd, &uchar, 1);
            write(fd, temp->name, uchar);
         }
         for (pkt = temp->ap->pkts; pkt; pkt = pkt->next) {
            len = pkt->len + 6;
            write(fd, &len, sizeof(int));
            write(fd, temp->bssid, 6);
            write(fd, pkt->buf, pkt->len);
         }
         len = 11;
         for (i = 0; i < 13; i++) {
            for (samp = temp->ap->samples[i]; samp; samp = samp->next) {
               write(fd, &len, sizeof(int));
               write(fd, temp->bssid, 6);
               write(fd, samp->iv, 3);
               write(fd, &dummy, 1);
               first = samp->firstByte ^ 0xAA;
               write(fd, &first, 1);
            }
         }
      }
   }
   close(fd);
   if (quitting) {
      doCapture = 0;
      gtk_main_quit();
   }
}

void
on_savefile_cancel                     (GtkButton       *button,
                                        gpointer         user_data)
{
   if (quitting) {
      doCapture = 0;
      gtk_main_quit();
   }
}

void
on_stats_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
fprintf(stderr, "stats\n");
}

void
on_delete_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
int row, column, result;
fprintf(stderr, "delete\n");

result = gtk_clist_get_selection_info(theList, popupEvent->x, popupEvent->y, &row, &column);
if (result) {
fprintf(stderr, "row = %d, col = %d\n", row, column);
}
else {
   fprintf(stderr, "not found\n");
}
}


void
on_stop_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
fprintf(stderr, "stop\n");
}


void
on_gps_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   gtk_widget_show_all (create_GpsDialog());
}


void
on_GpsOk_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_PrefsOkGetDev_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   strcpy(dev, gtk_entry_get_text(GTK_ENTRY(user_data)));
}


void
on_PrefsOkOrinoco_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   useOrinoco = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(user_data));
}


void
on_DeviceName_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
   gtk_entry_set_text(GTK_ENTRY(widget), dev);
}


void
on_Orinoco_realize                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), useOrinoco);
}


void
on_PrefsOkGetPacket_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
   use_PF_PACKET = !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(user_data));
}


void
on_PFnetlink_realize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
   if (use_PF_PACKET) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(user_data), TRUE);
   }
   else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
   }
}
