<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.0">

<!-- ####################################### -->
<!-- ####################################### -->
<!-- Creates an HTML coverpage for the album -->
<xsl:template match="album" mode="coverpage">
<xsl:document method="html" indent="yes" href="{concat($outputPath, '/Album.html')}"> 
<html>
  <head>
    <meta name="generator" content="Album Shaper (c.) Will Stokes"/>

    <style type="text/css">
      &lt;!--

	a:link		{color:#0066ff;		text-decoration: none;		font-size:8pt}
	a:active	{color:#0066ff;		text-decoration: none;		font-size:8pt}
	a:visited	{color:#0066ff;		text-decoration: none;		font-size:8pt}
	a:hover 	{color:#ffffff; 	text-decoration: none; 		font-size:8pt}
      
	font.title{		font-size:			14pt;
					font-weight:		normal;
					text-transform:		uppercase;
					background-color:	#222222;
					color:				#0066ff;
					letter-spacing:		5pt;
					font-family:		"Arial Black";}
	font.desc{		font-size:			10pt;
					font-weight:		normal;
					font-style:			italic;
					color:				white;
					font-family:		"Arial";}
	font.subTxt{	color:				#0066ff;
					font-weight:		thin;
					font-size:			10pt;
					font-family:		"Times New Roman";
					text-transform:		lowercase;}
	font.credits{	color:				#aaaaaa;
					font-weight:		thin;
					font-style:			italic;
					font-size:			8pt;
					font-family:		"Times New Roman";
					background-color:	#222222}
	
				 
	div.imgBox{		border-width:		0;
					background-color:	#000000;
					padding:			5px;
					position:			absolute;
					left:				0;
					top:				0;}
	div.txtBox{		position:			absolute;
					left:				8;
					top:				318;}
	div.titBox{		position:			relative;
					padding:			3px;
					background-color:	black;}
	div.outerSubBox{position:			absolute;
					left:				0;
					top:				400;
					background-color:	black;
					padding:			5;}
	div.subTxtBox{	background-color:	#222222;}
	div.creditBox{	position:			absolute;
					left:				5;
					top:				600;
					padding:			2px;
					background-color:	black;}

		
      
      --&gt;
    </style>
    <title><xsl:value-of select="name"/></title>
  </head>
  <body bgcolor="#000000" text="#ffffff" background="resources/scanline.jpg">
  
	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- ALBUM IMAGE IN UPPER LEFT    -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <div class="imgBox">
	<xsl:if test="thumb">
	<xsl:variable name="albumThumbnail" select="thumb/@path"/>
	<img src="{$albumThumbnail}" alt="Representative Album Image"/>
	</xsl:if>
	</div>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    
    
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- WRITE OUT NAME & DESCRIPTION -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <div class="txtBox">
    <br/>
    <div class="titBox">
	<font class="title">
	<xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
	<xsl:value-of select="name"/>
	<xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
	</font>
	</div>
	<font class="desc"><xsl:value-of select="description"/></font>
	</div>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    
    
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- HANDLE SUBALBUMS             -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <div class="outerSubBox">    
    <table>
      <tr>
	<xsl:for-each select="subalbum">
	    <td>
	    
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY SUBALBUM THUMBNAIL   -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<xsl:if test="thumb">
			<xsl:variable name="subalbumThumbnail" select="thumb/@path"/>
				<script type="text/javascript" language="JavaScript">
                        <![CDATA[
                        <!-- HIDE FROM OLD BROWSERS
                        document.write("<a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">")
                        document.write("  <img alt=\"Subalbum ]]><xsl:value-of select="position()"/><![CDATA[\" src=\"]]><xsl:value-of select="$subalbumThumbnail"/><![CDATA[\" border=\"0\"/>")
                        document.write("</a>")
                        -->
                        ]]>
				</script>
			<noscript>
				<a href="subalbum_{position()}_thumbs.html"><img src="{$subalbumThumbnail}" border="0" /></a>
			</noscript>	
		</xsl:if>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	
	
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- DISPLAY THE SUBALBUM TITLE   -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<center><div class="subTxtBox"><font class="subTxt">
		<script type="text/javascript" language="JavaScript">
                      <![CDATA[
                      <!-- HIDE FROM OLD BROWSERS
                      document.write("<a href=\"subalbum_]]><xsl:value-of select="position()"/><![CDATA[_slideshow.html\">")
                      document.write("  ]]><xsl:value-of select="name"/><![CDATA[")
                      document.write("</a>")
                      -->
                      ]]>
		</script>
		<noscript>
			<a href="subalbum_{position()}_thumbs.html"><xsl:value-of select="name"/></a>
		</noscript>		
		</font></div></center>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<!-- NO IDEA WHAT THIS DOES       -->
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		<xsl:if test="not(position() mod 3)">
			<xsl:text disable-output-escaping="yes"> &lt;/tr&gt;&lt;tr&gt;</xsl:text>
		</xsl:if>
		<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
		
		
	    </td>
	</xsl:for-each>
	  </tr>
    </table>
        
    
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<!-- NO IDEA WHAT THIS DOES       -->
	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:call-template name="endRow">
		<xsl:with-param name="cellsLeft" select="(3 - (count(subalbum) mod 3))"/>
	</xsl:call-template>
	</div>
	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	
	
	<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <!-- DISPLAY THE CREDITS          -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<div  class="creditBox">
	<font class="credits">
      <xsl:variable name="Cyear"  select="substring-before(created, ' ')"/>
      <xsl:variable name="Cmonth" select="substring-before( substring-after(created, ' '), ' ')"/>
      <xsl:variable name="Cday"   select="substring-after( substring-after(created, ' '), ' ')"/>
      <xsl:variable name="Myear"  select="substring-before(modified, ' ')"/>
      <xsl:variable name="Mmonth" select="substring-before( substring-after(modified, ' '), ' ')"/>
      <xsl:variable name="Mday"   select="substring-after( substring-after(modified, ' '), ' ')"/>
	  <!-- last modified	<xsl:value-of select="$Mmonth"/>/<xsl:value-of select="$Mday"/>/<xsl:value-of select="$Myear"/> -->
      created by <xsl:value-of select="author"/> using <a href="http://albumshaper.sourceforge.net">Album Shaper</a>, on <xsl:value-of select="$Cmonth"/>/<xsl:value-of select="$Cday"/>/<xsl:value-of select="$Cyear"/>.
	</font>
    </div>
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    
    
  </body>
</html>
</xsl:document>
</xsl:template>
<!-- ####################################### -->
<!-- ####################################### -->

</xsl:stylesheet>
