//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef BACKEND_MANIPULATIONS_BLUR_H
#define BACKEND_MANIPULATIONS_BLUR_H

//--------------------
//forward declarations
//--------------------
class QImage;

//Blur image
void blurImage( QImage &image, float sigma );

//Blur an image, but take into consideration edge data
//by bluring specifically the edges or the regions inbetween
void blurImage( QImage &image, float sigma,
                QPoint offset, QSize fullImageRes,
                QImage* edges, int* regions, int numRegions,
                bool targetEdges);



#endif //BACKEND_MANIPULATIONS_BLUR_H
