//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef CONFIGURATION_LAYOUTSETTINGSWIDGET_H
#define CONFIGURATION_LAYOUTSETTINGSWIDGET_H

//window placement
#define CENTER 0
#define TOP_LEFT 1
#define TOP_RIGHT 2
#define BOTTOM_LEFT 3
#define BOTTOM_RIGHT 4

#include <qdialog.h>

//forward declarations
class QGridLayout;
class QLabel;
class QCheckBox;
class QSlider;
class QSpinBox;
class QVGroupBox;
class QFrame;
class QPushButton;
class QComboBox;
class Configuration;

//=====================================
/*! \brief Layout Settings
 */
//=====================================

//======================
class LayoutSettingsWidget : public QWidget
{
Q_OBJECT
//----------------------
public:
  LayoutSettingsWidget( Configuration* config, QWidget *parent=0, const char* name=0);
  static void setDefaults(Configuration* config);
  void loadSettings();
  void saveSettings();
//----------------------
private slots:
  void defaultSizeSliderMoved(int val);
  void defaultSizeSpinboxChanged(int val);
  void toggleDefaultSizeEnabled(bool b);
private:
  ///Backend config object pointer
  Configuration* config;

  QGridLayout* mainGrid;
  //-------
  //Main Category and separation line
  QLabel* categoryLabel;
  QFrame* horizontalLine;
  //-------
  //General Settings
  QVGroupBox* generalSettings;
  QCheckBox* photosBackgroundImage;
  QCheckBox* useAnimation;
  QCheckBox* showTooltips;
  //-------
  //Window Placement and Size Controls
  QFrame* sizeFrame;
  QGridLayout* manualPlacementGrid;
  QVGroupBox* windowPlacementSize;
  QCheckBox* restoreWindowPlacementSize;

  QLabel* defaultWindowSizeLabel;
  QSlider* defaultWindowSizeSlider;
  QSpinBox* defaultWindowSizeValue;

  QLabel* defaultWindowPlacementLabel;
  QComboBox* defaultWindowPlacement;
//----------------------
};
//======================

#endif //CONFIGURATION_LAYOUTSETTINGSWIDGET_H
