//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qiconview.h>

//Projectwide includes
#include "items.h"
#include "item.h"

//==============================================
Items::Items( QWidget* parent,
                      const char* name ) : QIconView( parent, name)
{
  currentPseudoSelection = NULL;
//  setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Minimum);

  //connect mouse over events to paint pseudo selection in ligher blue
  connect( this, SIGNAL(onItem(QIconViewItem*)),
                this, SLOT(repaintGroup(QIconViewItem*)) );

  //clear any pseudo selection when mouse moves off icons
  connect( this, SIGNAL(onViewport()),
                this, SLOT(clearPseudoSelection()) );
}
//==============================================
void Items::keyPressEvent( QKeyEvent* e )
{
  //change key left/right presses to up/down events
  int key = e->key();
  if( key == Key_Left) key = Key_Up;
  if( key == Key_Right) key = Key_Down;

  QIconView::keyPressEvent(
    new QKeyEvent(QEvent::KeyPress,
              key,
              e->ascii(),
              e->state(),
              e->text(),
              e->isAutoRepeat(),
              e->count() ) );
}
//==============================================
QSize Items::sizeHint() const
{
  QSize s = QIconView::sizeHint();

  //find max item width
  s.setWidth(0);
  QIconViewItem *item;
  for( item = firstItem(); item != NULL; item = item->nextItem() )
  {
    if(item->width() + 2 > s.width() )
      s.setWidth( item->width() );
  }
  s.setWidth( s.width() + 2*spacing() );
  return s;
}
//==============================================
void Items::repaintGroup( QIconViewItem* pseudoSelection)
{
  //if old pseudo selection unselect it
  clearPseudoSelection();

  //paint new selection
  currentPseudoSelection = (Item*)pseudoSelection;
  currentPseudoSelection->setMousedOver(true);
  repaintItem(currentPseudoSelection);
}
//==============================================
void Items::clearPseudoSelection()
{
  //if old pseudo selection unselect it
  if(currentPseudoSelection != NULL)
  {
    currentPseudoSelection->setMousedOver(false);
    repaintItem(currentPseudoSelection);
    currentPseudoSelection = NULL;
  }
}
//==============================================
