// ---------------------------------------------------------------------------
// - Lexer.hpp                                                               -
// - aleph engine - lexical analyzer class definition                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_LEXER_HPP
#define  ALEPH_LEXER_HPP

#ifndef  ALEPH_INPUT_HPP
#include "Input.hpp"
#endif

#ifndef  ALEPH_BUFFER_HPP
#include "Buffer.hpp"
#endif

#ifndef  ALEPH_TOKEN_HPP
#include "Token.hpp"
#endif

namespace aleph {

  /// The Lexer class implements the functionality of a lexical analyzer for 
  /// the aleph system. The lexical analyzer consumes character from an input 
  /// stream and generate the appropriate object when one has been constructed.
  /// @author amaury darsch

  class Lexer {
  private:
    /// the input stream
    Input* p_is;
    /// the current line number
    long d_lnum;
    /// the buffer used for accumulation
    Buffer d_buffer;

  public:
    /// create a new lexical analyzer
    /// @param is the input stream
    Lexer (Input* is);

    /// destroy this lexer
    ~Lexer (void);

    /// @return the next token from this stream
    Token get (void);

    /// @return the lexer line number
    long getlnum (void) const {
      return d_lnum;
    }

  private:
    // make the copy constructor private
    Lexer (const Lexer&);
    // make the assignement operator private
    Lexer& operator = (const Lexer&);
  };
}

#endif
