// ---------------------------------------------------------------------------
// - Digest.hpp                                                              -
// - aleph:txt library - message digest class definition                     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_DIGEST_HPP
#define  ALEPH_DIGEST_HPP

#ifndef  ALEPH_BUFFER_HPP
#include "Buffer.hpp"
#endif

namespace aleph {

  /// The Digest class is a class that can be used to compute a message
  /// digest. The message digest algorithm is defined during the class
  /// construction.
  /// @author amaury darsch

  class Digest : public Object {
  public:
    /// the message digest algoirthm
    enum t_algo {
      MD5 = 0  // the MD5 algorithm
    };

  private:
    /// the digest algorithm
    t_algo d_algo;
    /// the digest context
    void*  d_dctx;

  public:
    /// create a default digest
    Digest (void);

    /// destroy digest
    ~Digest (void);

    /// @return the class name
    String repr (void) const;

    /// compute a message digest from a string
    String compute (const String& msg);

    /// generate a new digest object
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// apply digest object with a set of arguments and a quark
    /// @param robj  robj the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);

  private:
    // make the copy constructor private
    Digest (const Digest&);
    // make the assignment operator private
    Digest& operator = (const Digest&);
  };
}

#endif
