
set lSex {Unset Female Male}
set lOnline {{All users} {Only online users}}
set lLanguages { Unset Arabic Bhojpuri Bulgarian Burmese Cantonese Catalan 
				Chinese Croatian Czech Danish Dutch English Esperanto
				Estonian Farsi Finnish French Gaelic German Greek Hebrew
				Hindi Hungarian Icelandic Indonesian Italian Japanese Khmer
				Korean Lao Latvian Lithuanian Malay Norwegian Polish
				Portuguese Romanian Russian Serbian Slovak Slovenian Somali
				Spanish Swahili Swedish Tagalog Tatar Thai Turkish Ukrainian
				Urdu Vietnamese Yiddish Yoruba Afrikaans Bosnian Persian
				Albanian Armenian Punjabi Chamorro Mongolian Mandarin
				Taiwaness Macedonian Sindhi Welsh Azerbaijani Kurdish Gujarati
				Tamil Belarusian Unknown
}
array set aCountries { 
	0 Unset 1 USA 7 Russia 20 Egypt 27 {South Africa} 30 Greece 31 Netherlands
	32 Belgium 33 France 34 Spain 36 Hungary 38 Yugoslavia
	39 Italy 40 Romania 41 Switzerland 42 {Czech Republic} 43 Austria
	44 UK 45 Denmark 46 Sweden 47 Norway 48 Poland 49 Germany 51 Peru 
	52 Mexico 53 Cuba 54 Argentina 55 Brazil 56 Chile 57 Columbia 58 Venezuela
	60 Malaysia 61 Australia 62 Indonesia 63 Philippines 64 {New Zealand}
	65 Singapore 66 Thailand 81 Japan 82 {South Korea} 84 Vietnam 86 China
	90 Turkey 91 India 92 Pakistan 93 Afghanistan 94 {Sri Lanka} 95 Myanmar
	98 Iran 101 Anguilla 102 Antigua 103 Bahamas 104 Barbados 105 Bermuda 
	106 {British Virgin Islands} 107 Canada 108 {Cayman Islands} 109 Dominica
	110 {Dominican Republic} 111 Grenada 112 Jamaica 113 Montserrat 114 Nevis 
	115 {St. Kitts} 116 {St. Vincent and the Grenadines} 
	117 {Trinidad and Tobago} 118 {Turks and Caicos Islands} 120 Barbuda
	121 {Puerto Rico} 122 {Saint Lucia} 123 {US Virgin Islands}
	212 Morocco 213 Algeria 216 Tunisia 218 Libya 221 Senegal 223 Mali 
	224 Guinea 225 {Ivory Coast} 226 {Burkina Faso} 227 Niger 228 Togo
	229 Benin 230 Mauritius 231 Liberia 232 {Sierra Leone} 233 Ghana
	234 Nigeria 235 Chad 236 {Central African Republic} 237 Cameroon
	238 {Cape Verde Islands} 239 {Sao Tome and Principe} 240 {Equatorial Guinea}
	241 Gabon 242 Congo 243 Zaire 244 Angola 245 Guinea-Bissau
	246 {Diego Garcia} 247 {Ascension Island} 248 {Seychelle Islands} 249 Sudan
	250 Rwanda 251 Ethiopia 252 Somalia 253 Djibouti 254 Kenya 255 Tanzania
	256 Uganda 257 Burundi 258 Mozambique 260 Zambia 261 Madagascar
	262 {Reunion Island} 263 Zimbabwe 264 Namibia 265 Malawi 266 Lesotho
	267 Botswana 268 Swaziland 269 {Mayotte Island} 290 {St. Helena}
	291 Eritrea 297 Aruba 297 {Faeroe Islands} 299 Greenland 350 Gibraltar
	351 Portugal 352 Luxembourg 353 Ireland 354 Iceland 356 Malta 357 Cyprus
	358 Finland 359 Bulgaria 370 Lithuania 371 Latvia 372 Estonia 373 Moldova
	374 Armenia 375 Belarus 376 Andorra 377 Monaco 371 {San Marino}
	379 {Vatican City} 380 Ukraine 381 Yugoslavia 385 Croatia 386 Slovenia
	387 {Bosnia and Herzegovina} 389 Macedonia 500 {Falkland Islands}
	501 Belize 502 Guatemala 503 {El Salvador} 504 Honduras 505 Nicaragua
	506 {Costa Rice} 507 Panama 508 {St. Pierre and Miquelon} 509 Haiti
	590 Guadeloupe 591 Bolivia 592 Guyana 593 Ecuador 594 {French Guiana}
	595 Paraguay 596 {French Antilles} 597 Suriname 598 Uruguay 
	599 {Netherlands Antilles} 670 Saipan 671 Guam 672 {Christmas Island}
	673 Brunei 674 Nauru 675 {Papua New Guinea} 676 Tonga 677 {Solomon Islands}
	678 Vanuatu	679 Fiji 680 Palau 681 {Wallis and Futuna Islands}
	682 {Cook Islands} 683 Niue 684 {American Samoa} 685 {Western Samoa}
	686 Kiribati 687 {New Caledonia} 688 Tuvalu 689 {French Polynesia}
	690 Tokelau 691 Micronesia 692 {Marshall Islands} 705 Kazakhstan
	706 {Kyrgyz Republic} 708 Tajikistan 709 Turkmenistan 711 Uzbekistan
	850 {North Korea} 852 {Hong Kong} 853 Macau 855 Cambodia 856 Laos
	868 {Trinidad and Tobago} 880 Bangladesh 886 Taiwan 960 Maldives
	961 Lebanon 962 Jordan 963 Syria 964 Iraq 965 Kuwait 966 {Saudia Arabia}
	967 Yemen 968 Oman 971 {United Arab Emirates} 972 Israel 973 Bahrain
	974 Qatar 975 Bhutan 976 Mongolia 977 Nepal 994 Azerbaijan 995 Georgia
	4101 Liechtenstein 4201 {Slovak Republic} 65535 {Not entered}
} 
array set aTimeZones {0 {0 (Greenwich)} 
		1  {-00:30} 2  {-01:00} 3  {-01:30} 4  {-02:00} 
		5  {-02:30} 6  {-03:00} 7  {-03:30} 8  {-04:00}
		9  {-04:30} 10 {-05:00} 11 {-05:30} 12 {-06:00} 
		13 {-06:30} 14 {-07:00} 15 {-07:30} 16 {-08:00} 
		17 {-09:00} 18 {-09:30} 19 {-10:00} 20 {-10:30}
		21 {-11:00} 22 {-11:30}
		-1  {+00:30} -2  {+01:00} -3  {+01:30} -4  {+02:00}
		-5  {+02:30} -6  {+03:00} -7  {+03:30} -8  {+04:00}
		-9  {+04:30} -10 {+05:00} -11 {+05:30} -12 {+06:00}
		-13 {+06:30} -14 {+07:00} -15 {+07:30} -16 {+08:00} 
		-17 {+09:00} -18 {+09:30} -19 {+10:00} -20 {+10:30} 
		-21 {+11:00} -22 {+11:30}
}

set metaContact { 
	{type label page Main id Alias row 1 col 0} 
	{type label page Main id UIN row 1 col 2}
	{type entry page Main id Nick row 1 col 1 } 
	{type entry page Main id UIN row 1 col 3 ro yes}
	{type label page Main id Status row 2 col 0}
	{type label page Main id IP row 2 col 2}
	{type entry page Main id Status row 2 col 1 ro yes} 
	{type entry page Main id IP row 2 col 3 ro yes}
	                      
	{type label page Main id Name row 4 col 0 }
	{type entry page Main id FirstName row 4 col 1}
	{type entry page Main id LastName row 4 col 2 colspan 2}
	{type label page Main id {E-mail} row 5 col 0}
	{type label page Main id {E-mail 1} row 5 col 2}
	{type entry page Main id email row 5 col 1 }
	{type entry page Main id email0 row 5 col 3 }
	{type label page Main id {E-mail 2} row 6 col 0} 
	{type label page Main id {E-mail 3} row 6 col 2}
	{type entry page Main id email1 row 6 col 1 } 
	{type entry page Main id email2 row 6 col 3 }
	{type label page Main id Homepage row 21 col 0} 
	{type entry page Main id Homepage row 21 col 1 colspan 3}
	
	{type label page where id Country row 11 col 0} 
	{type label page where id City row 11 col 2}
	{type array page where id Country row 11 col 1 idx whitepages::aCountries} 
	{type entry page where id City row 11 col 3}	
	{type label page where id State row 12 col 0} 
	{type label page where id Zip row 12 col 2}
	{type entry page where id State row 12 col 1}
	{type entry page where id Zip row 12 col 3}	
	{type label page where id Address row 13 col 0}
	{type entry page where id Street row 13 col 1 colspan 3}
	{type label page where id Phone row 14 col 0}
	{type label page where id Fax row 14 col 2}
	{type entry page where id Phone row 14 col 1} 
	{type entry page where id Fax row 14 col 3}	
	{type label page where id {Cell phone} row 15 col 0} 
	{type label page where id {Time Zone} row 15 col 2}
	{type entry page where id Mobile row 15 col 1} 
	{type array page where id TimeZone row 15 col 3 idx whitepages::aTimeZones}	
                          
	{type label page more id Sex row 20 col 0}
	{type label page more id Age row 20 col 2}
	{type list  page more id Sex row 20 col 1 idx whitepages::lSex}
	{type entry page more id Age row 20 col 3}	
	{type label page more id Birthday row 22 col 0 colspan 2}
	{type label page more id Languages row 22 col 2 colspan 2}
	{type label page more id Day row 23 col 0} 
	{type entry page more id Day row 23 col 1} 
	{type label page more id Month row 24 col 0}
	{type entry page more id Month row 24 col 1} 
	{type label page more id Year row 25 col 0} 
	{type entry page more id Year row 25 col 1} 
	{type label page more id {Language 1} row 23 col 2} 
	{type label page more id {Language 2} row 24 col 2}
	{type label page more id {Language 3} row 25 col 2} 
	{type list  page more id Lang1 row 23 col 3 idx whitepages::lLanguages} 
	{type list  page more id Lang2 row 24 col 3 idx whitepages::lLanguages}
	{type list  page more id Lang3 row 25 col 3 idx whitepages::lLanguages}
}
set metaSearch {
	{type label id Nick row 1 col 0}	
	{type label id E-mail row 1 col 2}	
	{type label id Name row 2 col 0}
	{type label id Sex row 3 col 0}
	{type label id Language row 3 col 2}
	{type label id Country row 4 col 0}
	{type label id City row 4 col 2}
	{type label id {Min age} row 5 col 0}
	{type label id {Max age} row 5 col 2}
	{type label id Online row 6 col 0}

	{type entry id Nick row 1 col 1}
	{type entry id Email row 1 col 3}
	{type entry id FirstName row 2 col 1}
	{type entry id LastName row 2 col 2 colspan 2}
	{type list  id Sex row 3 col 1 idx whitepages::lSex}
	{type list  id Language row 3 col 3 idx whitepages::lLanguages}
	{type array id Country row 4 col 1 idx whitepages::aCountries}
	{type entry id City row 4 col 3}
	{type entry id MinAge row 5 col 1}
	{type entry id MaxAge row 5 col 3}
	{type list  id ONlineOnly row 6 col 1 idx whitepages::lOnline}
}

proc ContactInfoHandler {uin ref {type view} myref Info} {
	if {$myref!=$ref} return
	set top .user:$uin
	if {![winfo exists $top]} return
	if {$Info=={}} {$top configure -cursor {}; return}
	array set info $Info
	foreach item $whitepages::metaContact {
		array set curr $item
		if {$curr(type)=="label"} continue
		set key $curr(id)
		if {![info exists info($key)]} continue
		if {$curr(type)=="list"} { 
			set info($key) [lindex [set $curr(idx)] $info($key)]
		}  elseif {$curr(type)=="array" } {
			set info($key) [set $curr(idx)($info($key))]
		}
		set page [$top.nb getframe $curr(page)]
		if {$curr(type)=="entry" || $type=="view"} {
			$page.entry_$key configure -state normal
			$page.entry_$key delete 0 end
			$page.entry_$key insert 0 $info($key)
			if {$type=="view" || ([info exists curr(ro)] &&\
				[string is true $curr(ro)])} {
				$page.entry_$key configure -state disabled
			}
		} elseif {$curr(type)=="list" || $curr(type)=="array"} {
			set [$page.$curr(type)_$key cget -textvariable] $info($key)
		}
		if {$key=="Nick" && [info exists ::Contacts($uin:Alias)] &&\
			[regexp {^[0-9]+$} $::Contacts($uin:Alias)]} {
				set ::Contacts($uin:Alias) $val
		}
		unset curr	
	}
	unset info
}
proc UpdatePersonalInfo {top} {
	set Info [GatherInfo $top whitepages::metaContact]
	puts $Info
	icq::UpdateInfo $Info
}
proc GatherInfo {top metaVar} {
	set Info {}
	foreach item [set $metaVar] {
		array set attr $item
		set val {}
		set prefix $top.nb
		if [info exists attr(page)] {set prefix [$top.nb getframe $attr(page)]}
		switch $attr(type) {
			entry { set val [$prefix.$attr(type)_$attr(id) get] }
			list { set val [lsearch [set $attr(idx)]\
						[set whitepages::tmp_$attr(id)]]
				   if {$val==-1} {set val {}}
			}
			array { 
				foreach {id name} [array get $attr(idx)] {
					if [string equal $name [set whitepages::tmp_$attr(id)]] {
						set val $id; break}
				}
			}
		}
		if {$val!={}} {lappend Info $attr(id) $val}
	}
	return $Info
}
proc ContactInfoDialog {top {type view}} {
	if [catch {toplevel $top -class AlicqInfoWindow}] return
	MetaDialog whitepages::metaContact $top $type yes
	pack [frame $top.btn -borderwidth 1] -fill x
	button $top.btn.ok -text "Update"\
		-command "whitepages::UpdatePersonalInfo $top"
	button $top.btn.cancel -text "Close" -command "destroy $top"
	if {$type=="view"} {$top.btn.ok configure -state disabled}
	pack $top.btn.ok $top.btn.cancel -side left -expand yes
}
set found {}
proc SearchDialog {} {
	set top .search
	if [catch {toplevel $top}] return
	MetaDialog whitepages::metaSearch $top update
	pack [frame $top.results -borderwidth 1] -expand yes -fill both
	pack [listbox $top.results.list -selectmode single] -expand yes -fill both
	pack [label $top.results.status -relief groove] -fill x
	pack [frame $top.btn -borderwidth 1] -fill x
	set cmd "whitepages::SearchRun $top"
	button $top.btn.search -text "Search" -command $cmd
	button $top.btn.moreinfo -state disabled -text "More info"\
			-command {whitepages::ContactInfo [whitepages::GetFoundItem] Full}
	button $top.btn.add -state disabled -text "Add"\
		-command {set u [whitepages::GetFoundItem]; ::AddContact $u {} $u; unset u}
	button $top.btn.close -text "Close" \
			-command "unset ::whitepages::found; destroy $top"
	pack $top.btn.search  $top.btn.moreinfo $top.btn.add $top.btn.close\
		-side left -expand yes
	Hook SearchResults ::whitepages::SearchResults
	bind $top <Destroy> {RemoveHook SearchResults ::whitepages::SearchResults}
}

proc CheckPage {top page} {
	if {[$top.nb index $page]==-1} {
		$top.nb insert end $page -text $page
		set frame [$top.nb getframe $page]
		foreach {num weight pad} {0 0 2 1 1 2 2 0 2 3 1 2} {
			grid columnconfig $frame $num -weight $weight -pad $pad
		}
	} else { set frame [$top.nb getframe $page] }
	return $frame
}
proc MetaDialog {metaVar top {type view} {paged no}} {
	if [string is true $paged] {
		set frame [NoteBook $top.nb]
	} else {
		set frame [frame $top.nb] 
	}
	pack $frame -fill x
	foreach item [set $metaVar] {
		array set attr $item
		set prefix $top.nb
		if [string is true $paged] { set prefix [CheckPage $top $attr(page)] }
		switch $attr(type) {
			label { label $prefix.label_$attr(id) -text $attr(id)
			}
			entry { entry $prefix.entry_$attr(id)
			}
			array -
			list {
				if {$type=="view"} {
					set attr(type) entry	
					entry $prefix.$attr(type)_$attr(id) 
				} else {
					set	m $prefix.$attr(type)_$attr(id).m 
					set ::whitepages::tmp_$attr(id) {}
					menubutton $prefix.$attr(type)_$attr(id) -menu $m \
						-relief groove -textvariable whitepages::tmp_$attr(id)\
						-anchor w 
					menu $m -tearoff no
					set mn $m
					if {$attr(type)=="array"} {
							set Items {}
							foreach {id name} [array get $attr(idx)] {
								lappend Items $name	
							}
					} else { set Items [set $attr(idx)] }
					set count [llength $Items]
					$mn add radiobutton -label Unset \
						-variable whitepages::tmp_$attr(id) 
					foreach item [lsort $Items] {
						if {$item=="Unset"} continue	
						set first [string range $item 0 0]
						if {$count>30 && ![winfo exists $m.l_$first]} {
							set mn $m.l_$first
							menu $mn -tearoff no
							$m add cascade -label $first -menu $mn
						}
						$mn add radiobutton -label $item \
							-variable whitepages::tmp_$attr(id) 
					}
				}
			}
		}
		if {$attr(type)=="entry" && $type=="view" || [info exists attr(ro)] && \
				[string is true $attr(ro)] } {
				$prefix.$attr(type)_$attr(id) configure -state disabled 
		}
		set colspan 1
		if [info exists attr(colspan)] {set colspan $attr(colspan)}
		grid $prefix.$attr(type)_$attr(id) -row $attr(row)\
				-column $attr(col) -columnspan $colspan -sticky we
		unset attr
	}
	if [string is true $paged] {$top.nb raise [$top.nb pages 0]}
	#$top configure -cursor watch
}

proc ContactInfo {uin Type {state view}} {
	set ref [expr [clock seconds] & 0xff]
 	Hook ContactInfo "whitepages::ContactInfoHandler $uin $ref $state"
	ContactInfoDialog .user:$uin $state
	ContactInfoHandler $uin $ref $state $ref [list UIN $uin]
	if [info exists ::Contacts($uin:IP)] {
		ContactInfoHandler $uin $ref $state $ref [list IP $::Contacts($uin:IP)]
	}
	icq::${Type}InfoRequest $uin $ref
}

proc MenuContactInfo {} { 
	foreach {group uin} [split $::base::CurrentNode :] break
	ContactInfo $uin Full
}

proc SearchRun {top} {
	$top.results.list delete 0 end
	$top configure -cursor watch
	$top.btn.moreinfo configure -state disabled
	$top.btn.add configure -state disabled
	$top.results.status configure -text "Searching..."
	set ::whitepages::found {}
	set Info [GatherInfo $top whitepages::metaSearch]
	icq::Search $Info
}

proc SearchResults {Ref Info} {
	if {$Info=={}} { 
		.search configure -cursor {}
		.search.results.status configure -text "Search complete"
		return 
	}
	array set user $Info
	lappend ::whitepages::found $user(UIN)
	.search.btn.moreinfo configure -state normal
	.search.btn.add configure -state normal
	.search.results.list insert end "$user(UIN): $user(Nick) \($user(FirstName) $user(LastName): $user(email)\)"
	.search.results.list selection set 0
	unset user
}

proc GetFoundItem {} {
	set idx [lindex [.search.results.list curselection] 0]
	return [lindex $whitepages::found $idx]
}

.context insert History command -label "Info" \
		-command whitepages::MenuContactInfo
.main.m insert {*log} command -label "Personal Info" \
		-command {whitepages::ContactInfo $::Contacts(me:Uin) Full update}
.main.m insert {*log} command -label "Search" -command whitepages::SearchDialog 

